/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The order in which compute environments are tried for job placement within a queue. Compute environments are tried in
 * ascending order. For example, if two compute environments are associated with a job queue, the compute environment
 * with a lower order integer value is tried for job placement first.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeEnvironmentOrder implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeEnvironmentOrder.Builder, ComputeEnvironmentOrder> {
    private static final SdkField<Integer> ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ComputeEnvironmentOrder::order)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()).build();

    private static final SdkField<String> COMPUTE_ENVIRONMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ComputeEnvironmentOrder::computeEnvironment)).setter(setter(Builder::computeEnvironment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeEnvironment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDER_FIELD,
            COMPUTE_ENVIRONMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer order;

    private final String computeEnvironment;

    private ComputeEnvironmentOrder(BuilderImpl builder) {
        this.order = builder.order;
        this.computeEnvironment = builder.computeEnvironment;
    }

    /**
     * <p>
     * The order of the compute environment.
     * </p>
     * 
     * @return The order of the compute environment.
     */
    public Integer order() {
        return order;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the compute environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the compute environment.
     */
    public String computeEnvironment() {
        return computeEnvironment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(order());
        hashCode = 31 * hashCode + Objects.hashCode(computeEnvironment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeEnvironmentOrder)) {
            return false;
        }
        ComputeEnvironmentOrder other = (ComputeEnvironmentOrder) obj;
        return Objects.equals(order(), other.order()) && Objects.equals(computeEnvironment(), other.computeEnvironment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ComputeEnvironmentOrder").add("Order", order()).add("ComputeEnvironment", computeEnvironment())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "order":
            return Optional.ofNullable(clazz.cast(order()));
        case "computeEnvironment":
            return Optional.ofNullable(clazz.cast(computeEnvironment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeEnvironmentOrder, T> g) {
        return obj -> g.apply((ComputeEnvironmentOrder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeEnvironmentOrder> {
        /**
         * <p>
         * The order of the compute environment.
         * </p>
         * 
         * @param order
         *        The order of the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder order(Integer order);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the compute environment.
         * </p>
         * 
         * @param computeEnvironment
         *        The Amazon Resource Name (ARN) of the compute environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeEnvironment(String computeEnvironment);
    }

    static final class BuilderImpl implements Builder {
        private Integer order;

        private String computeEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeEnvironmentOrder model) {
            order(model.order);
            computeEnvironment(model.computeEnvironment);
        }

        public final Integer getOrder() {
            return order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        public final String getComputeEnvironment() {
            return computeEnvironment;
        }

        @Override
        public final Builder computeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        public final void setComputeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
        }

        @Override
        public ComputeEnvironmentOrder build() {
            return new ComputeEnvironmentOrder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
