/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.batch.model.ContainerDetail;
import software.amazon.awssdk.services.batch.transform.KeyValuePairUnmarshaller;
import software.amazon.awssdk.services.batch.transform.MountPointUnmarshaller;
import software.amazon.awssdk.services.batch.transform.UlimitUnmarshaller;
import software.amazon.awssdk.services.batch.transform.VolumeUnmarshaller;

public class ContainerDetailUnmarshaller
implements Unmarshaller<ContainerDetail, JsonUnmarshallerContext> {
    private static final ContainerDetailUnmarshaller INSTANCE = new ContainerDetailUnmarshaller();

    public ContainerDetail unmarshall(JsonUnmarshallerContext context) throws Exception {
        ContainerDetail.Builder containerDetailBuilder = ContainerDetail.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("image", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.image((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("vcpus", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.vcpus((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("memory", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.memory((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("command", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.command(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("jobRoleArn", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.jobRoleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("volumes", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.volumes(new ListUnmarshaller((Unmarshaller)VolumeUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("environment", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.environment(new ListUnmarshaller((Unmarshaller)KeyValuePairUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("mountPoints", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.mountPoints(new ListUnmarshaller((Unmarshaller)MountPointUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("readonlyRootFilesystem", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.readonlyRootFilesystem((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("ulimits", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.ulimits(new ListUnmarshaller((Unmarshaller)UlimitUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("privileged", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.privileged((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("user", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.user((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("exitCode", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.exitCode((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("reason", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.reason((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("containerInstanceArn", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.containerInstanceArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("taskArn", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.taskArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("logStreamName", targetDepth)) {
                    context.nextToken();
                    containerDetailBuilder.logStreamName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ContainerDetail)containerDetailBuilder.build();
    }

    public static ContainerDetailUnmarshaller getInstance() {
        return INSTANCE;
    }
}

