/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.batch.model.RetryStrategy;

public class RetryStrategyUnmarshaller
implements Unmarshaller<RetryStrategy, JsonUnmarshallerContext> {
    private static final RetryStrategyUnmarshaller INSTANCE = new RetryStrategyUnmarshaller();

    public RetryStrategy unmarshall(JsonUnmarshallerContext context) throws Exception {
        RetryStrategy.Builder retryStrategyBuilder = RetryStrategy.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("attempts", targetDepth)) {
                    context.nextToken();
                    retryStrategyBuilder.attempts((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (RetryStrategy)retryStrategyBuilder.build();
    }

    public static RetryStrategyUnmarshaller getInstance() {
        return INSTANCE;
    }
}

