/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.batch.model.JobQueueDetail;
import software.amazon.awssdk.services.batch.model.JobQueueDetailListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobQueuesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeJobQueuesResponse> {
    private final List<JobQueueDetail> jobQueues;
    private final String nextToken;

    private DescribeJobQueuesResponse(BuilderImpl builder) {
        this.jobQueues = builder.jobQueues;
        this.nextToken = builder.nextToken;
    }

    public List<JobQueueDetail> jobQueues() {
        return this.jobQueues;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobQueues() == null ? 0 : this.jobQueues().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobQueuesResponse)) {
            return false;
        }
        DescribeJobQueuesResponse other = (DescribeJobQueuesResponse)((Object)obj);
        if (other.jobQueues() == null ^ this.jobQueues() == null) {
            return false;
        }
        if (other.jobQueues() != null && !other.jobQueues().equals(this.jobQueues())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobQueues() != null) {
            sb.append("JobQueues: ").append(this.jobQueues()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<JobQueueDetail> jobQueues;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobQueuesResponse model) {
            this.setJobQueues(model.jobQueues);
            this.setNextToken(model.nextToken);
        }

        public final Collection<JobQueueDetail> getJobQueues() {
            return this.jobQueues;
        }

        @Override
        public final Builder jobQueues(Collection<JobQueueDetail> jobQueues) {
            this.jobQueues = JobQueueDetailListCopier.copy(jobQueues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobQueues(JobQueueDetail ... jobQueues) {
            this.jobQueues(Arrays.asList(jobQueues));
            return this;
        }

        public final void setJobQueues(Collection<JobQueueDetail> jobQueues) {
            this.jobQueues = JobQueueDetailListCopier.copy(jobQueues);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeJobQueuesResponse build() {
            return new DescribeJobQueuesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeJobQueuesResponse> {
        public Builder jobQueues(Collection<JobQueueDetail> var1);

        public Builder jobQueues(JobQueueDetail ... var1);

        public Builder nextToken(String var1);
    }
}

