/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.batch.model.ContainerOverrides;
import software.amazon.awssdk.services.batch.model.JobDependency;
import software.amazon.awssdk.services.batch.model.JobDependencyListCopier;
import software.amazon.awssdk.services.batch.model.ParametersMapCopier;
import software.amazon.awssdk.services.batch.model.RetryStrategy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SubmitJobRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SubmitJobRequest> {
    private final String jobName;
    private final String jobQueue;
    private final List<JobDependency> dependsOn;
    private final String jobDefinition;
    private final Map<String, String> parameters;
    private final ContainerOverrides containerOverrides;
    private final RetryStrategy retryStrategy;

    private SubmitJobRequest(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobQueue = builder.jobQueue;
        this.dependsOn = builder.dependsOn;
        this.jobDefinition = builder.jobDefinition;
        this.parameters = builder.parameters;
        this.containerOverrides = builder.containerOverrides;
        this.retryStrategy = builder.retryStrategy;
    }

    public String jobName() {
        return this.jobName;
    }

    public String jobQueue() {
        return this.jobQueue;
    }

    public List<JobDependency> dependsOn() {
        return this.dependsOn;
    }

    public String jobDefinition() {
        return this.jobDefinition;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public ContainerOverrides containerOverrides() {
        return this.containerOverrides;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobName() == null ? 0 : this.jobName().hashCode());
        hashCode = 31 * hashCode + (this.jobQueue() == null ? 0 : this.jobQueue().hashCode());
        hashCode = 31 * hashCode + (this.dependsOn() == null ? 0 : this.dependsOn().hashCode());
        hashCode = 31 * hashCode + (this.jobDefinition() == null ? 0 : this.jobDefinition().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.containerOverrides() == null ? 0 : this.containerOverrides().hashCode());
        hashCode = 31 * hashCode + (this.retryStrategy() == null ? 0 : this.retryStrategy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitJobRequest)) {
            return false;
        }
        SubmitJobRequest other = (SubmitJobRequest)((Object)obj);
        if (other.jobName() == null ^ this.jobName() == null) {
            return false;
        }
        if (other.jobName() != null && !other.jobName().equals(this.jobName())) {
            return false;
        }
        if (other.jobQueue() == null ^ this.jobQueue() == null) {
            return false;
        }
        if (other.jobQueue() != null && !other.jobQueue().equals(this.jobQueue())) {
            return false;
        }
        if (other.dependsOn() == null ^ this.dependsOn() == null) {
            return false;
        }
        if (other.dependsOn() != null && !other.dependsOn().equals(this.dependsOn())) {
            return false;
        }
        if (other.jobDefinition() == null ^ this.jobDefinition() == null) {
            return false;
        }
        if (other.jobDefinition() != null && !other.jobDefinition().equals(this.jobDefinition())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.containerOverrides() == null ^ this.containerOverrides() == null) {
            return false;
        }
        if (other.containerOverrides() != null && !other.containerOverrides().equals(this.containerOverrides())) {
            return false;
        }
        if (other.retryStrategy() == null ^ this.retryStrategy() == null) {
            return false;
        }
        return other.retryStrategy() == null || other.retryStrategy().equals(this.retryStrategy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobName() != null) {
            sb.append("JobName: ").append(this.jobName()).append(",");
        }
        if (this.jobQueue() != null) {
            sb.append("JobQueue: ").append(this.jobQueue()).append(",");
        }
        if (this.dependsOn() != null) {
            sb.append("DependsOn: ").append(this.dependsOn()).append(",");
        }
        if (this.jobDefinition() != null) {
            sb.append("JobDefinition: ").append(this.jobDefinition()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.containerOverrides() != null) {
            sb.append("ContainerOverrides: ").append(this.containerOverrides()).append(",");
        }
        if (this.retryStrategy() != null) {
            sb.append("RetryStrategy: ").append(this.retryStrategy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String jobQueue;
        private List<JobDependency> dependsOn;
        private String jobDefinition;
        private Map<String, String> parameters;
        private ContainerOverrides containerOverrides;
        private RetryStrategy retryStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitJobRequest model) {
            this.setJobName(model.jobName);
            this.setJobQueue(model.jobQueue);
            this.setDependsOn(model.dependsOn);
            this.setJobDefinition(model.jobDefinition);
            this.setParameters(model.parameters);
            this.setContainerOverrides(model.containerOverrides);
            this.setRetryStrategy(model.retryStrategy);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobQueue() {
            return this.jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final Collection<JobDependency> getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public final Builder dependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(JobDependency ... dependsOn) {
            this.dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        public final void setDependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
        }

        @SafeVarargs
        public final void setDependsOn(JobDependency ... dependsOn) {
            this.dependsOn(Arrays.asList(dependsOn));
        }

        public final String getJobDefinition() {
            return this.jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final ContainerOverrides getContainerOverrides() {
            return this.containerOverrides;
        }

        @Override
        public final Builder containerOverrides(ContainerOverrides containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public final void setContainerOverrides(ContainerOverrides containerOverrides) {
            this.containerOverrides = containerOverrides;
        }

        public final RetryStrategy getRetryStrategy() {
            return this.retryStrategy;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
        }

        public SubmitJobRequest build() {
            return new SubmitJobRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SubmitJobRequest> {
        public Builder jobName(String var1);

        public Builder jobQueue(String var1);

        public Builder dependsOn(Collection<JobDependency> var1);

        public Builder dependsOn(JobDependency ... var1);

        public Builder jobDefinition(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder containerOverrides(ContainerOverrides var1);

        public Builder retryStrategy(RetryStrategy var1);
    }
}

