/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.batch.model.KeyValuePair;
import software.amazon.awssdk.services.batch.model.MountPoint;
import software.amazon.awssdk.services.batch.model.MountPointsCopier;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.services.batch.model.Ulimit;
import software.amazon.awssdk.services.batch.model.UlimitsCopier;
import software.amazon.awssdk.services.batch.model.Volume;
import software.amazon.awssdk.services.batch.model.VolumesCopier;
import software.amazon.awssdk.services.batch.transform.ContainerPropertiesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ContainerProperties
implements StructuredPojo,
ToCopyableBuilder<Builder, ContainerProperties> {
    private final String image;
    private final Integer vcpus;
    private final Integer memory;
    private final List<String> command;
    private final String jobRoleArn;
    private final List<Volume> volumes;
    private final List<KeyValuePair> environment;
    private final List<MountPoint> mountPoints;
    private final Boolean readonlyRootFilesystem;
    private final Boolean privileged;
    private final List<Ulimit> ulimits;
    private final String user;

    private ContainerProperties(BuilderImpl builder) {
        this.image = builder.image;
        this.vcpus = builder.vcpus;
        this.memory = builder.memory;
        this.command = builder.command;
        this.jobRoleArn = builder.jobRoleArn;
        this.volumes = builder.volumes;
        this.environment = builder.environment;
        this.mountPoints = builder.mountPoints;
        this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
        this.privileged = builder.privileged;
        this.ulimits = builder.ulimits;
        this.user = builder.user;
    }

    public String image() {
        return this.image;
    }

    public Integer vcpus() {
        return this.vcpus;
    }

    public Integer memory() {
        return this.memory;
    }

    public List<String> command() {
        return this.command;
    }

    public String jobRoleArn() {
        return this.jobRoleArn;
    }

    public List<Volume> volumes() {
        return this.volumes;
    }

    public List<KeyValuePair> environment() {
        return this.environment;
    }

    public List<MountPoint> mountPoints() {
        return this.mountPoints;
    }

    public Boolean readonlyRootFilesystem() {
        return this.readonlyRootFilesystem;
    }

    public Boolean privileged() {
        return this.privileged;
    }

    public List<Ulimit> ulimits() {
        return this.ulimits;
    }

    public String user() {
        return this.user;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.image() == null ? 0 : this.image().hashCode());
        hashCode = 31 * hashCode + (this.vcpus() == null ? 0 : this.vcpus().hashCode());
        hashCode = 31 * hashCode + (this.memory() == null ? 0 : this.memory().hashCode());
        hashCode = 31 * hashCode + (this.command() == null ? 0 : this.command().hashCode());
        hashCode = 31 * hashCode + (this.jobRoleArn() == null ? 0 : this.jobRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.volumes() == null ? 0 : this.volumes().hashCode());
        hashCode = 31 * hashCode + (this.environment() == null ? 0 : this.environment().hashCode());
        hashCode = 31 * hashCode + (this.mountPoints() == null ? 0 : this.mountPoints().hashCode());
        hashCode = 31 * hashCode + (this.readonlyRootFilesystem() == null ? 0 : this.readonlyRootFilesystem().hashCode());
        hashCode = 31 * hashCode + (this.privileged() == null ? 0 : this.privileged().hashCode());
        hashCode = 31 * hashCode + (this.ulimits() == null ? 0 : this.ulimits().hashCode());
        hashCode = 31 * hashCode + (this.user() == null ? 0 : this.user().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerProperties)) {
            return false;
        }
        ContainerProperties other = (ContainerProperties)obj;
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.vcpus() == null ^ this.vcpus() == null) {
            return false;
        }
        if (other.vcpus() != null && !other.vcpus().equals(this.vcpus())) {
            return false;
        }
        if (other.memory() == null ^ this.memory() == null) {
            return false;
        }
        if (other.memory() != null && !other.memory().equals(this.memory())) {
            return false;
        }
        if (other.command() == null ^ this.command() == null) {
            return false;
        }
        if (other.command() != null && !other.command().equals(this.command())) {
            return false;
        }
        if (other.jobRoleArn() == null ^ this.jobRoleArn() == null) {
            return false;
        }
        if (other.jobRoleArn() != null && !other.jobRoleArn().equals(this.jobRoleArn())) {
            return false;
        }
        if (other.volumes() == null ^ this.volumes() == null) {
            return false;
        }
        if (other.volumes() != null && !other.volumes().equals(this.volumes())) {
            return false;
        }
        if (other.environment() == null ^ this.environment() == null) {
            return false;
        }
        if (other.environment() != null && !other.environment().equals(this.environment())) {
            return false;
        }
        if (other.mountPoints() == null ^ this.mountPoints() == null) {
            return false;
        }
        if (other.mountPoints() != null && !other.mountPoints().equals(this.mountPoints())) {
            return false;
        }
        if (other.readonlyRootFilesystem() == null ^ this.readonlyRootFilesystem() == null) {
            return false;
        }
        if (other.readonlyRootFilesystem() != null && !other.readonlyRootFilesystem().equals(this.readonlyRootFilesystem())) {
            return false;
        }
        if (other.privileged() == null ^ this.privileged() == null) {
            return false;
        }
        if (other.privileged() != null && !other.privileged().equals(this.privileged())) {
            return false;
        }
        if (other.ulimits() == null ^ this.ulimits() == null) {
            return false;
        }
        if (other.ulimits() != null && !other.ulimits().equals(this.ulimits())) {
            return false;
        }
        if (other.user() == null ^ this.user() == null) {
            return false;
        }
        return other.user() == null || other.user().equals(this.user());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.image() != null) {
            sb.append("Image: ").append(this.image()).append(",");
        }
        if (this.vcpus() != null) {
            sb.append("Vcpus: ").append(this.vcpus()).append(",");
        }
        if (this.memory() != null) {
            sb.append("Memory: ").append(this.memory()).append(",");
        }
        if (this.command() != null) {
            sb.append("Command: ").append(this.command()).append(",");
        }
        if (this.jobRoleArn() != null) {
            sb.append("JobRoleArn: ").append(this.jobRoleArn()).append(",");
        }
        if (this.volumes() != null) {
            sb.append("Volumes: ").append(this.volumes()).append(",");
        }
        if (this.environment() != null) {
            sb.append("Environment: ").append(this.environment()).append(",");
        }
        if (this.mountPoints() != null) {
            sb.append("MountPoints: ").append(this.mountPoints()).append(",");
        }
        if (this.readonlyRootFilesystem() != null) {
            sb.append("ReadonlyRootFilesystem: ").append(this.readonlyRootFilesystem()).append(",");
        }
        if (this.privileged() != null) {
            sb.append("Privileged: ").append(this.privileged()).append(",");
        }
        if (this.ulimits() != null) {
            sb.append("Ulimits: ").append(this.ulimits()).append(",");
        }
        if (this.user() != null) {
            sb.append("User: ").append(this.user()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String image;
        private Integer vcpus;
        private Integer memory;
        private List<String> command;
        private String jobRoleArn;
        private List<Volume> volumes;
        private List<KeyValuePair> environment;
        private List<MountPoint> mountPoints;
        private Boolean readonlyRootFilesystem;
        private Boolean privileged;
        private List<Ulimit> ulimits;
        private String user;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerProperties model) {
            this.setImage(model.image);
            this.setVcpus(model.vcpus);
            this.setMemory(model.memory);
            this.setCommand(model.command);
            this.setJobRoleArn(model.jobRoleArn);
            this.setVolumes(model.volumes);
            this.setEnvironment(model.environment);
            this.setMountPoints(model.mountPoints);
            this.setReadonlyRootFilesystem(model.readonlyRootFilesystem);
            this.setPrivileged(model.privileged);
            this.setUlimits(model.ulimits);
            this.setUser(model.user);
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final Integer getVcpus() {
            return this.vcpus;
        }

        @Override
        public final Builder vcpus(Integer vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        public final void setVcpus(Integer vcpus) {
            this.vcpus = vcpus;
        }

        public final Integer getMemory() {
            return this.memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        public final Collection<String> getCommand() {
            return this.command;
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        @SafeVarargs
        public final void setCommand(String ... command) {
            this.command(Arrays.asList(command));
        }

        public final String getJobRoleArn() {
            return this.jobRoleArn;
        }

        @Override
        public final Builder jobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
            return this;
        }

        public final void setJobRoleArn(String jobRoleArn) {
            this.jobRoleArn = jobRoleArn;
        }

        public final Collection<Volume> getVolumes() {
            return this.volumes;
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        public final void setVolumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
        }

        @SafeVarargs
        public final void setVolumes(Volume ... volumes) {
            this.volumes(Arrays.asList(volumes));
        }

        public final Collection<KeyValuePair> getEnvironment() {
            return this.environment;
        }

        @Override
        public final Builder environment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(KeyValuePair ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        public final void setEnvironment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
        }

        @SafeVarargs
        public final void setEnvironment(KeyValuePair ... environment) {
            this.environment(Arrays.asList(environment));
        }

        public final Collection<MountPoint> getMountPoints() {
            return this.mountPoints;
        }

        @Override
        public final Builder mountPoints(Collection<MountPoint> mountPoints) {
            this.mountPoints = MountPointsCopier.copy(mountPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(MountPoint ... mountPoints) {
            this.mountPoints(Arrays.asList(mountPoints));
            return this;
        }

        public final void setMountPoints(Collection<MountPoint> mountPoints) {
            this.mountPoints = MountPointsCopier.copy(mountPoints);
        }

        @SafeVarargs
        public final void setMountPoints(MountPoint ... mountPoints) {
            this.mountPoints(Arrays.asList(mountPoints));
        }

        public final Boolean getReadonlyRootFilesystem() {
            return this.readonlyRootFilesystem;
        }

        @Override
        public final Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        public final void setReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
        }

        public final Boolean getPrivileged() {
            return this.privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        public final Collection<Ulimit> getUlimits() {
            return this.ulimits;
        }

        @Override
        public final Builder ulimits(Collection<Ulimit> ulimits) {
            this.ulimits = UlimitsCopier.copy(ulimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Ulimit ... ulimits) {
            this.ulimits(Arrays.asList(ulimits));
            return this;
        }

        public final void setUlimits(Collection<Ulimit> ulimits) {
            this.ulimits = UlimitsCopier.copy(ulimits);
        }

        @SafeVarargs
        public final void setUlimits(Ulimit ... ulimits) {
            this.ulimits(Arrays.asList(ulimits));
        }

        public final String getUser() {
            return this.user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        public ContainerProperties build() {
            return new ContainerProperties(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ContainerProperties> {
        public Builder image(String var1);

        public Builder vcpus(Integer var1);

        public Builder memory(Integer var1);

        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder jobRoleArn(String var1);

        public Builder volumes(Collection<Volume> var1);

        public Builder volumes(Volume ... var1);

        public Builder environment(Collection<KeyValuePair> var1);

        public Builder environment(KeyValuePair ... var1);

        public Builder mountPoints(Collection<MountPoint> var1);

        public Builder mountPoints(MountPoint ... var1);

        public Builder readonlyRootFilesystem(Boolean var1);

        public Builder privileged(Boolean var1);

        public Builder ulimits(Collection<Ulimit> var1);

        public Builder ulimits(Ulimit ... var1);

        public Builder user(String var1);
    }
}

