/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteObjectRequest extends BackupStorageRequest implements
        ToCopyableBuilder<DeleteObjectRequest.Builder, DeleteObjectRequest> {
    private static final SdkField<String> BACKUP_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupJobId").getter(getter(DeleteObjectRequest::backupJobId)).setter(setter(Builder::backupJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> OBJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectName").getter(getter(DeleteObjectRequest::objectName)).setter(setter(Builder::objectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("objectName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_JOB_ID_FIELD,
            OBJECT_NAME_FIELD));

    private final String backupJobId;

    private final String objectName;

    private DeleteObjectRequest(BuilderImpl builder) {
        super(builder);
        this.backupJobId = builder.backupJobId;
        this.objectName = builder.objectName;
    }

    /**
     * Backup job Id for the in-progress backup.
     * 
     * @return Backup job Id for the in-progress backup.
     */
    public final String backupJobId() {
        return backupJobId;
    }

    /**
     * The name of the Object.
     * 
     * @return The name of the Object.
     */
    public final String objectName() {
        return objectName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupJobId());
        hashCode = 31 * hashCode + Objects.hashCode(objectName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObjectRequest)) {
            return false;
        }
        DeleteObjectRequest other = (DeleteObjectRequest) obj;
        return Objects.equals(backupJobId(), other.backupJobId()) && Objects.equals(objectName(), other.objectName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteObjectRequest").add("BackupJobId", backupJobId()).add("ObjectName", objectName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupJobId":
            return Optional.ofNullable(clazz.cast(backupJobId()));
        case "ObjectName":
            return Optional.ofNullable(clazz.cast(objectName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteObjectRequest, T> g) {
        return obj -> g.apply((DeleteObjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupStorageRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteObjectRequest> {
        /**
         * Backup job Id for the in-progress backup.
         * 
         * @param backupJobId
         *        Backup job Id for the in-progress backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupJobId(String backupJobId);

        /**
         * The name of the Object.
         * 
         * @param objectName
         *        The name of the Object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectName(String objectName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupStorageRequest.BuilderImpl implements Builder {
        private String backupJobId;

        private String objectName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectRequest model) {
            super(model);
            backupJobId(model.backupJobId);
            objectName(model.objectName);
        }

        public final String getBackupJobId() {
            return backupJobId;
        }

        public final void setBackupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
        }

        @Override
        public final Builder backupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
            return this;
        }

        public final String getObjectName() {
            return objectName;
        }

        public final void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        @Override
        public final Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteObjectRequest build() {
            return new DeleteObjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
