/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupstorage.model.BackupObject;

final class ObjectListCopier {
    ObjectListCopier() {
    }

    static List<BackupObject> copy(Collection<? extends BackupObject> objectListParam) {
        Object list;
        if (objectListParam == null || objectListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            objectListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BackupObject> copyFromBuilder(Collection<? extends BackupObject.Builder> objectListParam) {
        Object list;
        if (objectListParam == null || objectListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            objectListParam.forEach(entry -> {
                BackupObject member = entry == null ? null : (BackupObject)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BackupObject.Builder> copyToBuilder(Collection<? extends BackupObject> objectListParam) {
        Object list;
        if (objectListParam == null || objectListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            objectListParam.forEach(entry -> {
                BackupObject.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

