/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupstorage.model.SummaryChecksumAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupObject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackupObject> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(BackupObject.getter(BackupObject::name)).setter(BackupObject.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Long> CHUNKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ChunksCount").getter(BackupObject.getter(BackupObject::chunksCount)).setter(BackupObject.setter(Builder::chunksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChunksCount").build()}).build();
    private static final SdkField<String> METADATA_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataString").getter(BackupObject.getter(BackupObject::metadataString)).setter(BackupObject.setter(Builder::metadataString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataString").build()}).build();
    private static final SdkField<String> OBJECT_CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectChecksum").getter(BackupObject.getter(BackupObject::objectChecksum)).setter(BackupObject.setter(Builder::objectChecksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectChecksum").build()}).build();
    private static final SdkField<String> OBJECT_CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectChecksumAlgorithm").getter(BackupObject.getter(BackupObject::objectChecksumAlgorithmAsString)).setter(BackupObject.setter(Builder::objectChecksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectChecksumAlgorithm").build()}).build();
    private static final SdkField<String> OBJECT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectToken").getter(BackupObject.getter(BackupObject::objectToken)).setter(BackupObject.setter(Builder::objectToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CHUNKS_COUNT_FIELD, METADATA_STRING_FIELD, OBJECT_CHECKSUM_FIELD, OBJECT_CHECKSUM_ALGORITHM_FIELD, OBJECT_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Long chunksCount;
    private final String metadataString;
    private final String objectChecksum;
    private final String objectChecksumAlgorithm;
    private final String objectToken;

    private BackupObject(BuilderImpl builder) {
        this.name = builder.name;
        this.chunksCount = builder.chunksCount;
        this.metadataString = builder.metadataString;
        this.objectChecksum = builder.objectChecksum;
        this.objectChecksumAlgorithm = builder.objectChecksumAlgorithm;
        this.objectToken = builder.objectToken;
    }

    public final String name() {
        return this.name;
    }

    public final Long chunksCount() {
        return this.chunksCount;
    }

    public final String metadataString() {
        return this.metadataString;
    }

    public final String objectChecksum() {
        return this.objectChecksum;
    }

    public final SummaryChecksumAlgorithm objectChecksumAlgorithm() {
        return SummaryChecksumAlgorithm.fromValue(this.objectChecksumAlgorithm);
    }

    public final String objectChecksumAlgorithmAsString() {
        return this.objectChecksumAlgorithm;
    }

    public final String objectToken() {
        return this.objectToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.chunksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataString());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectChecksumAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupObject)) {
            return false;
        }
        BackupObject other = (BackupObject)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.chunksCount(), other.chunksCount()) && Objects.equals(this.metadataString(), other.metadataString()) && Objects.equals(this.objectChecksum(), other.objectChecksum()) && Objects.equals(this.objectChecksumAlgorithmAsString(), other.objectChecksumAlgorithmAsString()) && Objects.equals(this.objectToken(), other.objectToken());
    }

    public final String toString() {
        return ToString.builder((String)"BackupObject").add("Name", (Object)this.name()).add("ChunksCount", (Object)this.chunksCount()).add("MetadataString", (Object)this.metadataString()).add("ObjectChecksum", (Object)this.objectChecksum()).add("ObjectChecksumAlgorithm", (Object)this.objectChecksumAlgorithmAsString()).add("ObjectToken", (Object)this.objectToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ChunksCount": {
                return Optional.ofNullable(clazz.cast(this.chunksCount()));
            }
            case "MetadataString": {
                return Optional.ofNullable(clazz.cast(this.metadataString()));
            }
            case "ObjectChecksum": {
                return Optional.ofNullable(clazz.cast(this.objectChecksum()));
            }
            case "ObjectChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.objectChecksumAlgorithmAsString()));
            }
            case "ObjectToken": {
                return Optional.ofNullable(clazz.cast(this.objectToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupObject, T> g) {
        return obj -> g.apply((BackupObject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Long chunksCount;
        private String metadataString;
        private String objectChecksum;
        private String objectChecksumAlgorithm;
        private String objectToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupObject model) {
            this.name(model.name);
            this.chunksCount(model.chunksCount);
            this.metadataString(model.metadataString);
            this.objectChecksum(model.objectChecksum);
            this.objectChecksumAlgorithm(model.objectChecksumAlgorithm);
            this.objectToken(model.objectToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getChunksCount() {
            return this.chunksCount;
        }

        public final void setChunksCount(Long chunksCount) {
            this.chunksCount = chunksCount;
        }

        @Override
        public final Builder chunksCount(Long chunksCount) {
            this.chunksCount = chunksCount;
            return this;
        }

        public final String getMetadataString() {
            return this.metadataString;
        }

        public final void setMetadataString(String metadataString) {
            this.metadataString = metadataString;
        }

        @Override
        public final Builder metadataString(String metadataString) {
            this.metadataString = metadataString;
            return this;
        }

        public final String getObjectChecksum() {
            return this.objectChecksum;
        }

        public final void setObjectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
        }

        @Override
        public final Builder objectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
            return this;
        }

        public final String getObjectChecksumAlgorithm() {
            return this.objectChecksumAlgorithm;
        }

        public final void setObjectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
        }

        @Override
        public final Builder objectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm(objectChecksumAlgorithm == null ? null : objectChecksumAlgorithm.toString());
            return this;
        }

        public final String getObjectToken() {
            return this.objectToken;
        }

        public final void setObjectToken(String objectToken) {
            this.objectToken = objectToken;
        }

        @Override
        public final Builder objectToken(String objectToken) {
            this.objectToken = objectToken;
            return this;
        }

        public BackupObject build() {
            return new BackupObject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackupObject> {
        public Builder name(String var1);

        public Builder chunksCount(Long var1);

        public Builder metadataString(String var1);

        public Builder objectChecksum(String var1);

        public Builder objectChecksumAlgorithm(String var1);

        public Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm var1);

        public Builder objectToken(String var1);
    }
}

