/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about a saved recovery point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryPointByResource implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryPointByResource.Builder, RecoveryPointByResource> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(RecoveryPointByResource::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(RecoveryPointByResource::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RecoveryPointByResource::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(RecoveryPointByResource::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(RecoveryPointByResource::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<Long> BACKUP_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BackupSizeBytes").getter(getter(RecoveryPointByResource::backupSizeBytes))
            .setter(setter(Builder::backupSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeBytes").build()).build();

    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(RecoveryPointByResource::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<Boolean> IS_PARENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsParent").getter(getter(RecoveryPointByResource::isParent)).setter(setter(Builder::isParent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsParent").build()).build();

    private static final SdkField<String> PARENT_RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentRecoveryPointArn").getter(getter(RecoveryPointByResource::parentRecoveryPointArn))
            .setter(setter(Builder::parentRecoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentRecoveryPointArn").build())
            .build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(RecoveryPointByResource::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> VAULT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VaultType").getter(getter(RecoveryPointByResource::vaultTypeAsString))
            .setter(setter(Builder::vaultType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultType").build()).build();

    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexStatus").getter(getter(RecoveryPointByResource::indexStatusAsString))
            .setter(setter(Builder::indexStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()).build();

    private static final SdkField<String> INDEX_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexStatusMessage").getter(getter(RecoveryPointByResource::indexStatusMessage))
            .setter(setter(Builder::indexStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatusMessage").build())
            .build();

    private static final SdkField<String> ENCRYPTION_KEY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyType").getter(getter(RecoveryPointByResource::encryptionKeyTypeAsString))
            .setter(setter(Builder::encryptionKeyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyType").build()).build();

    private static final SdkField<AggregatedScanResult> AGGREGATED_SCAN_RESULT_FIELD = SdkField
            .<AggregatedScanResult> builder(MarshallingType.SDK_POJO).memberName("AggregatedScanResult")
            .getter(getter(RecoveryPointByResource::aggregatedScanResult)).setter(setter(Builder::aggregatedScanResult))
            .constructor(AggregatedScanResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatedScanResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD,
            CREATION_DATE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, ENCRYPTION_KEY_ARN_FIELD, BACKUP_SIZE_BYTES_FIELD,
            BACKUP_VAULT_NAME_FIELD, IS_PARENT_FIELD, PARENT_RECOVERY_POINT_ARN_FIELD, RESOURCE_NAME_FIELD, VAULT_TYPE_FIELD,
            INDEX_STATUS_FIELD, INDEX_STATUS_MESSAGE_FIELD, ENCRYPTION_KEY_TYPE_FIELD, AGGREGATED_SCAN_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String recoveryPointArn;

    private final Instant creationDate;

    private final String status;

    private final String statusMessage;

    private final String encryptionKeyArn;

    private final Long backupSizeBytes;

    private final String backupVaultName;

    private final Boolean isParent;

    private final String parentRecoveryPointArn;

    private final String resourceName;

    private final String vaultType;

    private final String indexStatus;

    private final String indexStatusMessage;

    private final String encryptionKeyType;

    private final AggregatedScanResult aggregatedScanResult;

    private RecoveryPointByResource(BuilderImpl builder) {
        this.recoveryPointArn = builder.recoveryPointArn;
        this.creationDate = builder.creationDate;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.backupSizeBytes = builder.backupSizeBytes;
        this.backupVaultName = builder.backupVaultName;
        this.isParent = builder.isParent;
        this.parentRecoveryPointArn = builder.parentRecoveryPointArn;
        this.resourceName = builder.resourceName;
        this.vaultType = builder.vaultType;
        this.indexStatus = builder.indexStatus;
        this.indexStatusMessage = builder.indexStatusMessage;
        this.encryptionKeyType = builder.encryptionKeyType;
        this.aggregatedScanResult = builder.aggregatedScanResult;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * A status code specifying the state of the recovery point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecoveryPointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A status code specifying the state of the recovery point.
     * @see RecoveryPointStatus
     */
    public final RecoveryPointStatus status() {
        return RecoveryPointStatus.fromValue(status);
    }

    /**
     * <p>
     * A status code specifying the state of the recovery point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecoveryPointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A status code specifying the state of the recovery point.
     * @see RecoveryPointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message explaining the current status of the recovery point.
     * </p>
     * 
     * @return A message explaining the current status of the recovery point.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The server-side encryption key that is used to protect your backups; for example,
     * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * 
     * @return The server-side encryption key that is used to protect your backups; for example,
     *         <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * The size, in bytes, of a backup.
     * </p>
     * 
     * @return The size, in bytes, of a backup.
     */
    public final Long backupSizeBytes() {
        return backupSizeBytes;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the Amazon Web Services Region where they are created.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the Amazon Web Services Region where they are created.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * This is a boolean value indicating this is a parent (composite) recovery point.
     * </p>
     * 
     * @return This is a boolean value indicating this is a parent (composite) recovery point.
     */
    public final Boolean isParent() {
        return isParent;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the parent (composite) recovery point.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the parent (composite) recovery point.
     */
    public final String parentRecoveryPointArn() {
        return parentRecoveryPointArn;
    }

    /**
     * <p>
     * The non-unique name of the resource that belongs to the specified backup.
     * </p>
     * 
     * @return The non-unique name of the resource that belongs to the specified backup.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The type of vault in which the described recovery point is stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vaultType} will
     * return {@link VaultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vaultTypeAsString}.
     * </p>
     * 
     * @return The type of vault in which the described recovery point is stored.
     * @see VaultType
     */
    public final VaultType vaultType() {
        return VaultType.fromValue(vaultType);
    }

    /**
     * <p>
     * The type of vault in which the described recovery point is stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vaultType} will
     * return {@link VaultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vaultTypeAsString}.
     * </p>
     * 
     * @return The type of vault in which the described recovery point is stored.
     * @see VaultType
     */
    public final String vaultTypeAsString() {
        return vaultType;
    }

    /**
     * <p>
     * This is the current status for the backup index associated with the specified recovery point.
     * </p>
     * <p>
     * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     * </p>
     * <p>
     * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return This is the current status for the backup index associated with the specified recovery point.</p>
     *         <p>
     *         Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     *         </p>
     *         <p>
     *         A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * @see IndexStatus
     */
    public final IndexStatus indexStatus() {
        return IndexStatus.fromValue(indexStatus);
    }

    /**
     * <p>
     * This is the current status for the backup index associated with the specified recovery point.
     * </p>
     * <p>
     * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     * </p>
     * <p>
     * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return This is the current status for the backup index associated with the specified recovery point.</p>
     *         <p>
     *         Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     *         </p>
     *         <p>
     *         A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * @see IndexStatus
     */
    public final String indexStatusAsString() {
        return indexStatus;
    }

    /**
     * <p>
     * A string in the form of a detailed message explaining the status of a backup index associated with the recovery
     * point.
     * </p>
     * 
     * @return A string in the form of a detailed message explaining the status of a backup index associated with the
     *         recovery point.
     */
    public final String indexStatusMessage() {
        return indexStatusMessage;
    }

    /**
     * <p>
     * The type of encryption key used for the recovery point. Valid values are CUSTOMER_MANAGED_KMS_KEY for
     * customer-managed keys or Amazon Web Services_OWNED_KMS_KEY for Amazon Web Services-owned keys.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionKeyType}
     * will return {@link EncryptionKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionKeyTypeAsString}.
     * </p>
     * 
     * @return The type of encryption key used for the recovery point. Valid values are CUSTOMER_MANAGED_KMS_KEY for
     *         customer-managed keys or Amazon Web Services_OWNED_KMS_KEY for Amazon Web Services-owned keys.
     * @see EncryptionKeyType
     */
    public final EncryptionKeyType encryptionKeyType() {
        return EncryptionKeyType.fromValue(encryptionKeyType);
    }

    /**
     * <p>
     * The type of encryption key used for the recovery point. Valid values are CUSTOMER_MANAGED_KMS_KEY for
     * customer-managed keys or Amazon Web Services_OWNED_KMS_KEY for Amazon Web Services-owned keys.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionKeyType}
     * will return {@link EncryptionKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionKeyTypeAsString}.
     * </p>
     * 
     * @return The type of encryption key used for the recovery point. Valid values are CUSTOMER_MANAGED_KMS_KEY for
     *         customer-managed keys or Amazon Web Services_OWNED_KMS_KEY for Amazon Web Services-owned keys.
     * @see EncryptionKeyType
     */
    public final String encryptionKeyTypeAsString() {
        return encryptionKeyType;
    }

    /**
     * <p>
     * Contains the latest scanning results against the recovery point and currently include <code>FailedScan</code>,
     * <code>Findings</code>, <code>LastComputed</code>.
     * </p>
     * 
     * @return Contains the latest scanning results against the recovery point and currently include
     *         <code>FailedScan</code>, <code>Findings</code>, <code>LastComputed</code>.
     */
    public final AggregatedScanResult aggregatedScanResult() {
        return aggregatedScanResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(isParent());
        hashCode = 31 * hashCode + Objects.hashCode(parentRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(vaultTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregatedScanResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryPointByResource)) {
            return false;
        }
        RecoveryPointByResource other = (RecoveryPointByResource) obj;
        return Objects.equals(recoveryPointArn(), other.recoveryPointArn())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(backupSizeBytes(), other.backupSizeBytes())
                && Objects.equals(backupVaultName(), other.backupVaultName()) && Objects.equals(isParent(), other.isParent())
                && Objects.equals(parentRecoveryPointArn(), other.parentRecoveryPointArn())
                && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(vaultTypeAsString(), other.vaultTypeAsString())
                && Objects.equals(indexStatusAsString(), other.indexStatusAsString())
                && Objects.equals(indexStatusMessage(), other.indexStatusMessage())
                && Objects.equals(encryptionKeyTypeAsString(), other.encryptionKeyTypeAsString())
                && Objects.equals(aggregatedScanResult(), other.aggregatedScanResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryPointByResource").add("RecoveryPointArn", recoveryPointArn())
                .add("CreationDate", creationDate()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("EncryptionKeyArn", encryptionKeyArn()).add("BackupSizeBytes", backupSizeBytes())
                .add("BackupVaultName", backupVaultName()).add("IsParent", isParent())
                .add("ParentRecoveryPointArn", parentRecoveryPointArn()).add("ResourceName", resourceName())
                .add("VaultType", vaultTypeAsString()).add("IndexStatus", indexStatusAsString())
                .add("IndexStatusMessage", indexStatusMessage()).add("EncryptionKeyType", encryptionKeyTypeAsString())
                .add("AggregatedScanResult", aggregatedScanResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "BackupSizeBytes":
            return Optional.ofNullable(clazz.cast(backupSizeBytes()));
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "IsParent":
            return Optional.ofNullable(clazz.cast(isParent()));
        case "ParentRecoveryPointArn":
            return Optional.ofNullable(clazz.cast(parentRecoveryPointArn()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "VaultType":
            return Optional.ofNullable(clazz.cast(vaultTypeAsString()));
        case "IndexStatus":
            return Optional.ofNullable(clazz.cast(indexStatusAsString()));
        case "IndexStatusMessage":
            return Optional.ofNullable(clazz.cast(indexStatusMessage()));
        case "EncryptionKeyType":
            return Optional.ofNullable(clazz.cast(encryptionKeyTypeAsString()));
        case "AggregatedScanResult":
            return Optional.ofNullable(clazz.cast(aggregatedScanResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("BackupSizeBytes", BACKUP_SIZE_BYTES_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("IsParent", IS_PARENT_FIELD);
        map.put("ParentRecoveryPointArn", PARENT_RECOVERY_POINT_ARN_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("VaultType", VAULT_TYPE_FIELD);
        map.put("IndexStatus", INDEX_STATUS_FIELD);
        map.put("IndexStatusMessage", INDEX_STATUS_MESSAGE_FIELD);
        map.put("EncryptionKeyType", ENCRYPTION_KEY_TYPE_FIELD);
        map.put("AggregatedScanResult", AGGREGATED_SCAN_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecoveryPointByResource, T> g) {
        return obj -> g.apply((RecoveryPointByResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryPointByResource> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param recoveryPointArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value
         * of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationDate
         *        The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * A status code specifying the state of the recovery point.
         * </p>
         * 
         * @param status
         *        A status code specifying the state of the recovery point.
         * @see RecoveryPointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryPointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A status code specifying the state of the recovery point.
         * </p>
         * 
         * @param status
         *        A status code specifying the state of the recovery point.
         * @see RecoveryPointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryPointStatus
         */
        Builder status(RecoveryPointStatus status);

        /**
         * <p>
         * A message explaining the current status of the recovery point.
         * </p>
         * 
         * @param statusMessage
         *        A message explaining the current status of the recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The server-side encryption key that is used to protect your backups; for example,
         * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The server-side encryption key that is used to protect your backups; for example,
         *        <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * The size, in bytes, of a backup.
         * </p>
         * 
         * @param backupSizeBytes
         *        The size, in bytes, of a backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSizeBytes(Long backupSizeBytes);

        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the account used to create them and the Amazon Web Services Region where they are created.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the account used to create them and the Amazon Web Services Region where they are
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * This is a boolean value indicating this is a parent (composite) recovery point.
         * </p>
         * 
         * @param isParent
         *        This is a boolean value indicating this is a parent (composite) recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isParent(Boolean isParent);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the parent (composite) recovery point.
         * </p>
         * 
         * @param parentRecoveryPointArn
         *        The Amazon Resource Name (ARN) of the parent (composite) recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentRecoveryPointArn(String parentRecoveryPointArn);

        /**
         * <p>
         * The non-unique name of the resource that belongs to the specified backup.
         * </p>
         * 
         * @param resourceName
         *        The non-unique name of the resource that belongs to the specified backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The type of vault in which the described recovery point is stored.
         * </p>
         * 
         * @param vaultType
         *        The type of vault in which the described recovery point is stored.
         * @see VaultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VaultType
         */
        Builder vaultType(String vaultType);

        /**
         * <p>
         * The type of vault in which the described recovery point is stored.
         * </p>
         * 
         * @param vaultType
         *        The type of vault in which the described recovery point is stored.
         * @see VaultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VaultType
         */
        Builder vaultType(VaultType vaultType);

        /**
         * <p>
         * This is the current status for the backup index associated with the specified recovery point.
         * </p>
         * <p>
         * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         * </p>
         * <p>
         * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * </p>
         * 
         * @param indexStatus
         *        This is the current status for the backup index associated with the specified recovery point.</p>
         *        <p>
         *        Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         *        </p>
         *        <p>
         *        A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(String indexStatus);

        /**
         * <p>
         * This is the current status for the backup index associated with the specified recovery point.
         * </p>
         * <p>
         * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         * </p>
         * <p>
         * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * </p>
         * 
         * @param indexStatus
         *        This is the current status for the backup index associated with the specified recovery point.</p>
         *        <p>
         *        Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         *        </p>
         *        <p>
         *        A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(IndexStatus indexStatus);

        /**
         * <p>
         * A string in the form of a detailed message explaining the status of a backup index associated with the
         * recovery point.
         * </p>
         * 
         * @param indexStatusMessage
         *        A string in the form of a detailed message explaining the status of a backup index associated with the
         *        recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexStatusMessage(String indexStatusMessage);

        /**
         * <p>
         * The type of encryption key used for the recovery point. Valid values are CUSTOMER_MANAGED_KMS_KEY for
         * customer-managed keys or Amazon Web Services_OWNED_KMS_KEY for Amazon Web Services-owned keys.
         * </p>
         * 
         * @param encryptionKeyType
         *        The type of encryption key used for the recovery point. Valid values are CUSTOMER_MANAGED_KMS_KEY for
         *        customer-managed keys or Amazon Web Services_OWNED_KMS_KEY for Amazon Web Services-owned keys.
         * @see EncryptionKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionKeyType
         */
        Builder encryptionKeyType(String encryptionKeyType);

        /**
         * <p>
         * The type of encryption key used for the recovery point. Valid values are CUSTOMER_MANAGED_KMS_KEY for
         * customer-managed keys or Amazon Web Services_OWNED_KMS_KEY for Amazon Web Services-owned keys.
         * </p>
         * 
         * @param encryptionKeyType
         *        The type of encryption key used for the recovery point. Valid values are CUSTOMER_MANAGED_KMS_KEY for
         *        customer-managed keys or Amazon Web Services_OWNED_KMS_KEY for Amazon Web Services-owned keys.
         * @see EncryptionKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionKeyType
         */
        Builder encryptionKeyType(EncryptionKeyType encryptionKeyType);

        /**
         * <p>
         * Contains the latest scanning results against the recovery point and currently include <code>FailedScan</code>, <code>Findings</code>, <code>LastComputed</code>.
         * </p>
         * 
         * @param aggregatedScanResult
         *        Contains the latest scanning results against the recovery point and currently include
         *        <code>FailedScan</code>, <code>Findings</code>, <code>LastComputed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatedScanResult(AggregatedScanResult aggregatedScanResult);

        /**
         * <p>
         * Contains the latest scanning results against the recovery point and currently include <code>FailedScan</code>, <code>Findings</code>, <code>LastComputed</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregatedScanResult.Builder} avoiding
         * the need to create one manually via {@link AggregatedScanResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregatedScanResult.Builder#build()} is called immediately and
         * its result is passed to {@link #aggregatedScanResult(AggregatedScanResult)}.
         * 
         * @param aggregatedScanResult
         *        a consumer that will call methods on {@link AggregatedScanResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregatedScanResult(AggregatedScanResult)
         */
        default Builder aggregatedScanResult(Consumer<AggregatedScanResult.Builder> aggregatedScanResult) {
            return aggregatedScanResult(AggregatedScanResult.builder().applyMutation(aggregatedScanResult).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String recoveryPointArn;

        private Instant creationDate;

        private String status;

        private String statusMessage;

        private String encryptionKeyArn;

        private Long backupSizeBytes;

        private String backupVaultName;

        private Boolean isParent;

        private String parentRecoveryPointArn;

        private String resourceName;

        private String vaultType;

        private String indexStatus;

        private String indexStatusMessage;

        private String encryptionKeyType;

        private AggregatedScanResult aggregatedScanResult;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryPointByResource model) {
            recoveryPointArn(model.recoveryPointArn);
            creationDate(model.creationDate);
            status(model.status);
            statusMessage(model.statusMessage);
            encryptionKeyArn(model.encryptionKeyArn);
            backupSizeBytes(model.backupSizeBytes);
            backupVaultName(model.backupVaultName);
            isParent(model.isParent);
            parentRecoveryPointArn(model.parentRecoveryPointArn);
            resourceName(model.resourceName);
            vaultType(model.vaultType);
            indexStatus(model.indexStatus);
            indexStatusMessage(model.indexStatusMessage);
            encryptionKeyType(model.encryptionKeyType);
            aggregatedScanResult(model.aggregatedScanResult);
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecoveryPointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final Long getBackupSizeBytes() {
            return backupSizeBytes;
        }

        public final void setBackupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
        }

        @Override
        public final Builder backupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
            return this;
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final Boolean getIsParent() {
            return isParent;
        }

        public final void setIsParent(Boolean isParent) {
            this.isParent = isParent;
        }

        @Override
        public final Builder isParent(Boolean isParent) {
            this.isParent = isParent;
            return this;
        }

        public final String getParentRecoveryPointArn() {
            return parentRecoveryPointArn;
        }

        public final void setParentRecoveryPointArn(String parentRecoveryPointArn) {
            this.parentRecoveryPointArn = parentRecoveryPointArn;
        }

        @Override
        public final Builder parentRecoveryPointArn(String parentRecoveryPointArn) {
            this.parentRecoveryPointArn = parentRecoveryPointArn;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getVaultType() {
            return vaultType;
        }

        public final void setVaultType(String vaultType) {
            this.vaultType = vaultType;
        }

        @Override
        public final Builder vaultType(String vaultType) {
            this.vaultType = vaultType;
            return this;
        }

        @Override
        public final Builder vaultType(VaultType vaultType) {
            this.vaultType(vaultType == null ? null : vaultType.toString());
            return this;
        }

        public final String getIndexStatus() {
            return indexStatus;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final String getIndexStatusMessage() {
            return indexStatusMessage;
        }

        public final void setIndexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
        }

        @Override
        public final Builder indexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
            return this;
        }

        public final String getEncryptionKeyType() {
            return encryptionKeyType;
        }

        public final void setEncryptionKeyType(String encryptionKeyType) {
            this.encryptionKeyType = encryptionKeyType;
        }

        @Override
        public final Builder encryptionKeyType(String encryptionKeyType) {
            this.encryptionKeyType = encryptionKeyType;
            return this;
        }

        @Override
        public final Builder encryptionKeyType(EncryptionKeyType encryptionKeyType) {
            this.encryptionKeyType(encryptionKeyType == null ? null : encryptionKeyType.toString());
            return this;
        }

        public final AggregatedScanResult.Builder getAggregatedScanResult() {
            return aggregatedScanResult != null ? aggregatedScanResult.toBuilder() : null;
        }

        public final void setAggregatedScanResult(AggregatedScanResult.BuilderImpl aggregatedScanResult) {
            this.aggregatedScanResult = aggregatedScanResult != null ? aggregatedScanResult.build() : null;
        }

        @Override
        public final Builder aggregatedScanResult(AggregatedScanResult aggregatedScanResult) {
            this.aggregatedScanResult = aggregatedScanResult;
            return this;
        }

        @Override
        public RecoveryPointByResource build() {
            return new RecoveryPointByResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
