/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.RestoreDeletionStatus;
import software.amazon.awssdk.services.backup.model.RestoreJobCreator;
import software.amazon.awssdk.services.backup.model.RestoreJobStatus;
import software.amazon.awssdk.services.backup.model.RestoreValidationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreJobsListMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RestoreJobsListMember> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(RestoreJobsListMember.getter(RestoreJobsListMember::accountId)).setter(RestoreJobsListMember.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> RESTORE_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestoreJobId").getter(RestoreJobsListMember.getter(RestoreJobsListMember::restoreJobId)).setter(RestoreJobsListMember.setter(Builder::restoreJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreJobId").build()}).build();
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(RestoreJobsListMember.getter(RestoreJobsListMember::recoveryPointArn)).setter(RestoreJobsListMember.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(RestoreJobsListMember.getter(RestoreJobsListMember::creationDate)).setter(RestoreJobsListMember.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionDate").getter(RestoreJobsListMember.getter(RestoreJobsListMember::completionDate)).setter(RestoreJobsListMember.setter(Builder::completionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RestoreJobsListMember.getter(RestoreJobsListMember::statusAsString)).setter(RestoreJobsListMember.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(RestoreJobsListMember.getter(RestoreJobsListMember::statusMessage)).setter(RestoreJobsListMember.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> PERCENT_DONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PercentDone").getter(RestoreJobsListMember.getter(RestoreJobsListMember::percentDone)).setter(RestoreJobsListMember.setter(Builder::percentDone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentDone").build()}).build();
    private static final SdkField<Long> BACKUP_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BackupSizeInBytes").getter(RestoreJobsListMember.getter(RestoreJobsListMember::backupSizeInBytes)).setter(RestoreJobsListMember.setter(Builder::backupSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeInBytes").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(RestoreJobsListMember.getter(RestoreJobsListMember::iamRoleArn)).setter(RestoreJobsListMember.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<Long> EXPECTED_COMPLETION_TIME_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ExpectedCompletionTimeMinutes").getter(RestoreJobsListMember.getter(RestoreJobsListMember::expectedCompletionTimeMinutes)).setter(RestoreJobsListMember.setter(Builder::expectedCompletionTimeMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedCompletionTimeMinutes").build()}).build();
    private static final SdkField<String> CREATED_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedResourceArn").getter(RestoreJobsListMember.getter(RestoreJobsListMember::createdResourceArn)).setter(RestoreJobsListMember.setter(Builder::createdResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(RestoreJobsListMember.getter(RestoreJobsListMember::resourceType)).setter(RestoreJobsListMember.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Instant> RECOVERY_POINT_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RecoveryPointCreationDate").getter(RestoreJobsListMember.getter(RestoreJobsListMember::recoveryPointCreationDate)).setter(RestoreJobsListMember.setter(Builder::recoveryPointCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointCreationDate").build()}).build();
    private static final SdkField<RestoreJobCreator> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(RestoreJobsListMember.getter(RestoreJobsListMember::createdBy)).setter(RestoreJobsListMember.setter(Builder::createdBy)).constructor(RestoreJobCreator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationStatus").getter(RestoreJobsListMember.getter(RestoreJobsListMember::validationStatusAsString)).setter(RestoreJobsListMember.setter(Builder::validationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatus").build()}).build();
    private static final SdkField<String> VALIDATION_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationStatusMessage").getter(RestoreJobsListMember.getter(RestoreJobsListMember::validationStatusMessage)).setter(RestoreJobsListMember.setter(Builder::validationStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatusMessage").build()}).build();
    private static final SdkField<String> DELETION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeletionStatus").getter(RestoreJobsListMember.getter(RestoreJobsListMember::deletionStatusAsString)).setter(RestoreJobsListMember.setter(Builder::deletionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionStatus").build()}).build();
    private static final SdkField<String> DELETION_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeletionStatusMessage").getter(RestoreJobsListMember.getter(RestoreJobsListMember::deletionStatusMessage)).setter(RestoreJobsListMember.setter(Builder::deletionStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionStatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, RESTORE_JOB_ID_FIELD, RECOVERY_POINT_ARN_FIELD, CREATION_DATE_FIELD, COMPLETION_DATE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, PERCENT_DONE_FIELD, BACKUP_SIZE_IN_BYTES_FIELD, IAM_ROLE_ARN_FIELD, EXPECTED_COMPLETION_TIME_MINUTES_FIELD, CREATED_RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, RECOVERY_POINT_CREATION_DATE_FIELD, CREATED_BY_FIELD, VALIDATION_STATUS_FIELD, VALIDATION_STATUS_MESSAGE_FIELD, DELETION_STATUS_FIELD, DELETION_STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RestoreJobsListMember.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String restoreJobId;
    private final String recoveryPointArn;
    private final Instant creationDate;
    private final Instant completionDate;
    private final String status;
    private final String statusMessage;
    private final String percentDone;
    private final Long backupSizeInBytes;
    private final String iamRoleArn;
    private final Long expectedCompletionTimeMinutes;
    private final String createdResourceArn;
    private final String resourceType;
    private final Instant recoveryPointCreationDate;
    private final RestoreJobCreator createdBy;
    private final String validationStatus;
    private final String validationStatusMessage;
    private final String deletionStatus;
    private final String deletionStatusMessage;

    private RestoreJobsListMember(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.restoreJobId = builder.restoreJobId;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.percentDone = builder.percentDone;
        this.backupSizeInBytes = builder.backupSizeInBytes;
        this.iamRoleArn = builder.iamRoleArn;
        this.expectedCompletionTimeMinutes = builder.expectedCompletionTimeMinutes;
        this.createdResourceArn = builder.createdResourceArn;
        this.resourceType = builder.resourceType;
        this.recoveryPointCreationDate = builder.recoveryPointCreationDate;
        this.createdBy = builder.createdBy;
        this.validationStatus = builder.validationStatus;
        this.validationStatusMessage = builder.validationStatusMessage;
        this.deletionStatus = builder.deletionStatus;
        this.deletionStatusMessage = builder.deletionStatusMessage;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String restoreJobId() {
        return this.restoreJobId;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant completionDate() {
        return this.completionDate;
    }

    public final RestoreJobStatus status() {
        return RestoreJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String percentDone() {
        return this.percentDone;
    }

    public final Long backupSizeInBytes() {
        return this.backupSizeInBytes;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final Long expectedCompletionTimeMinutes() {
        return this.expectedCompletionTimeMinutes;
    }

    public final String createdResourceArn() {
        return this.createdResourceArn;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Instant recoveryPointCreationDate() {
        return this.recoveryPointCreationDate;
    }

    public final RestoreJobCreator createdBy() {
        return this.createdBy;
    }

    public final RestoreValidationStatus validationStatus() {
        return RestoreValidationStatus.fromValue(this.validationStatus);
    }

    public final String validationStatusAsString() {
        return this.validationStatus;
    }

    public final String validationStatusMessage() {
        return this.validationStatusMessage;
    }

    public final RestoreDeletionStatus deletionStatus() {
        return RestoreDeletionStatus.fromValue(this.deletionStatus);
    }

    public final String deletionStatusAsString() {
        return this.deletionStatus;
    }

    public final String deletionStatusMessage() {
        return this.deletionStatusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentDone());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedCompletionTimeMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionStatusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreJobsListMember)) {
            return false;
        }
        RestoreJobsListMember other = (RestoreJobsListMember)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.restoreJobId(), other.restoreJobId()) && Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.completionDate(), other.completionDate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.percentDone(), other.percentDone()) && Objects.equals(this.backupSizeInBytes(), other.backupSizeInBytes()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.expectedCompletionTimeMinutes(), other.expectedCompletionTimeMinutes()) && Objects.equals(this.createdResourceArn(), other.createdResourceArn()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.recoveryPointCreationDate(), other.recoveryPointCreationDate()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.validationStatusAsString(), other.validationStatusAsString()) && Objects.equals(this.validationStatusMessage(), other.validationStatusMessage()) && Objects.equals(this.deletionStatusAsString(), other.deletionStatusAsString()) && Objects.equals(this.deletionStatusMessage(), other.deletionStatusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreJobsListMember").add("AccountId", (Object)this.accountId()).add("RestoreJobId", (Object)this.restoreJobId()).add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("CreationDate", (Object)this.creationDate()).add("CompletionDate", (Object)this.completionDate()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("PercentDone", (Object)this.percentDone()).add("BackupSizeInBytes", (Object)this.backupSizeInBytes()).add("IamRoleArn", (Object)this.iamRoleArn()).add("ExpectedCompletionTimeMinutes", (Object)this.expectedCompletionTimeMinutes()).add("CreatedResourceArn", (Object)this.createdResourceArn()).add("ResourceType", (Object)this.resourceType()).add("RecoveryPointCreationDate", (Object)this.recoveryPointCreationDate()).add("CreatedBy", (Object)this.createdBy()).add("ValidationStatus", (Object)this.validationStatusAsString()).add("ValidationStatusMessage", (Object)this.validationStatusMessage()).add("DeletionStatus", (Object)this.deletionStatusAsString()).add("DeletionStatusMessage", (Object)this.deletionStatusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "RestoreJobId": {
                return Optional.ofNullable(clazz.cast(this.restoreJobId()));
            }
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CompletionDate": {
                return Optional.ofNullable(clazz.cast(this.completionDate()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "PercentDone": {
                return Optional.ofNullable(clazz.cast(this.percentDone()));
            }
            case "BackupSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.backupSizeInBytes()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "ExpectedCompletionTimeMinutes": {
                return Optional.ofNullable(clazz.cast(this.expectedCompletionTimeMinutes()));
            }
            case "CreatedResourceArn": {
                return Optional.ofNullable(clazz.cast(this.createdResourceArn()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "RecoveryPointCreationDate": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointCreationDate()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "ValidationStatus": {
                return Optional.ofNullable(clazz.cast(this.validationStatusAsString()));
            }
            case "ValidationStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.validationStatusMessage()));
            }
            case "DeletionStatus": {
                return Optional.ofNullable(clazz.cast(this.deletionStatusAsString()));
            }
            case "DeletionStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.deletionStatusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("RestoreJobId", RESTORE_JOB_ID_FIELD);
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("CompletionDate", COMPLETION_DATE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("PercentDone", PERCENT_DONE_FIELD);
        map.put("BackupSizeInBytes", BACKUP_SIZE_IN_BYTES_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("ExpectedCompletionTimeMinutes", EXPECTED_COMPLETION_TIME_MINUTES_FIELD);
        map.put("CreatedResourceArn", CREATED_RESOURCE_ARN_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("RecoveryPointCreationDate", RECOVERY_POINT_CREATION_DATE_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("ValidationStatus", VALIDATION_STATUS_FIELD);
        map.put("ValidationStatusMessage", VALIDATION_STATUS_MESSAGE_FIELD);
        map.put("DeletionStatus", DELETION_STATUS_FIELD);
        map.put("DeletionStatusMessage", DELETION_STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreJobsListMember, T> g) {
        return obj -> g.apply((RestoreJobsListMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String restoreJobId;
        private String recoveryPointArn;
        private Instant creationDate;
        private Instant completionDate;
        private String status;
        private String statusMessage;
        private String percentDone;
        private Long backupSizeInBytes;
        private String iamRoleArn;
        private Long expectedCompletionTimeMinutes;
        private String createdResourceArn;
        private String resourceType;
        private Instant recoveryPointCreationDate;
        private RestoreJobCreator createdBy;
        private String validationStatus;
        private String validationStatusMessage;
        private String deletionStatus;
        private String deletionStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreJobsListMember model) {
            this.accountId(model.accountId);
            this.restoreJobId(model.restoreJobId);
            this.recoveryPointArn(model.recoveryPointArn);
            this.creationDate(model.creationDate);
            this.completionDate(model.completionDate);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.percentDone(model.percentDone);
            this.backupSizeInBytes(model.backupSizeInBytes);
            this.iamRoleArn(model.iamRoleArn);
            this.expectedCompletionTimeMinutes(model.expectedCompletionTimeMinutes);
            this.createdResourceArn(model.createdResourceArn);
            this.resourceType(model.resourceType);
            this.recoveryPointCreationDate(model.recoveryPointCreationDate);
            this.createdBy(model.createdBy);
            this.validationStatus(model.validationStatus);
            this.validationStatusMessage(model.validationStatusMessage);
            this.deletionStatus(model.deletionStatus);
            this.deletionStatusMessage(model.deletionStatusMessage);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRestoreJobId() {
            return this.restoreJobId;
        }

        public final void setRestoreJobId(String restoreJobId) {
            this.restoreJobId = restoreJobId;
        }

        @Override
        public final Builder restoreJobId(String restoreJobId) {
            this.restoreJobId = restoreJobId;
            return this;
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getCompletionDate() {
            return this.completionDate;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RestoreJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getPercentDone() {
            return this.percentDone;
        }

        public final void setPercentDone(String percentDone) {
            this.percentDone = percentDone;
        }

        @Override
        public final Builder percentDone(String percentDone) {
            this.percentDone = percentDone;
            return this;
        }

        public final Long getBackupSizeInBytes() {
            return this.backupSizeInBytes;
        }

        public final void setBackupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
        }

        @Override
        public final Builder backupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final Long getExpectedCompletionTimeMinutes() {
            return this.expectedCompletionTimeMinutes;
        }

        public final void setExpectedCompletionTimeMinutes(Long expectedCompletionTimeMinutes) {
            this.expectedCompletionTimeMinutes = expectedCompletionTimeMinutes;
        }

        @Override
        public final Builder expectedCompletionTimeMinutes(Long expectedCompletionTimeMinutes) {
            this.expectedCompletionTimeMinutes = expectedCompletionTimeMinutes;
            return this;
        }

        public final String getCreatedResourceArn() {
            return this.createdResourceArn;
        }

        public final void setCreatedResourceArn(String createdResourceArn) {
            this.createdResourceArn = createdResourceArn;
        }

        @Override
        public final Builder createdResourceArn(String createdResourceArn) {
            this.createdResourceArn = createdResourceArn;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Instant getRecoveryPointCreationDate() {
            return this.recoveryPointCreationDate;
        }

        public final void setRecoveryPointCreationDate(Instant recoveryPointCreationDate) {
            this.recoveryPointCreationDate = recoveryPointCreationDate;
        }

        @Override
        public final Builder recoveryPointCreationDate(Instant recoveryPointCreationDate) {
            this.recoveryPointCreationDate = recoveryPointCreationDate;
            return this;
        }

        public final RestoreJobCreator.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(RestoreJobCreator.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(RestoreJobCreator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(RestoreValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        public final String getValidationStatusMessage() {
            return this.validationStatusMessage;
        }

        public final void setValidationStatusMessage(String validationStatusMessage) {
            this.validationStatusMessage = validationStatusMessage;
        }

        @Override
        public final Builder validationStatusMessage(String validationStatusMessage) {
            this.validationStatusMessage = validationStatusMessage;
            return this;
        }

        public final String getDeletionStatus() {
            return this.deletionStatus;
        }

        public final void setDeletionStatus(String deletionStatus) {
            this.deletionStatus = deletionStatus;
        }

        @Override
        public final Builder deletionStatus(String deletionStatus) {
            this.deletionStatus = deletionStatus;
            return this;
        }

        @Override
        public final Builder deletionStatus(RestoreDeletionStatus deletionStatus) {
            this.deletionStatus(deletionStatus == null ? null : deletionStatus.toString());
            return this;
        }

        public final String getDeletionStatusMessage() {
            return this.deletionStatusMessage;
        }

        public final void setDeletionStatusMessage(String deletionStatusMessage) {
            this.deletionStatusMessage = deletionStatusMessage;
        }

        @Override
        public final Builder deletionStatusMessage(String deletionStatusMessage) {
            this.deletionStatusMessage = deletionStatusMessage;
            return this;
        }

        public RestoreJobsListMember build() {
            return new RestoreJobsListMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RestoreJobsListMember> {
        public Builder accountId(String var1);

        public Builder restoreJobId(String var1);

        public Builder recoveryPointArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder completionDate(Instant var1);

        public Builder status(String var1);

        public Builder status(RestoreJobStatus var1);

        public Builder statusMessage(String var1);

        public Builder percentDone(String var1);

        public Builder backupSizeInBytes(Long var1);

        public Builder iamRoleArn(String var1);

        public Builder expectedCompletionTimeMinutes(Long var1);

        public Builder createdResourceArn(String var1);

        public Builder resourceType(String var1);

        public Builder recoveryPointCreationDate(Instant var1);

        public Builder createdBy(RestoreJobCreator var1);

        default public Builder createdBy(Consumer<RestoreJobCreator.Builder> createdBy) {
            return this.createdBy((RestoreJobCreator)((RestoreJobCreator.Builder)RestoreJobCreator.builder().applyMutation(createdBy)).build());
        }

        public Builder validationStatus(String var1);

        public Builder validationStatus(RestoreValidationStatus var1);

        public Builder validationStatusMessage(String var1);

        public Builder deletionStatus(String var1);

        public Builder deletionStatus(RestoreDeletionStatus var1);

        public Builder deletionStatusMessage(String var1);
    }
}

