/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackupJobSummary> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(BackupJobSummary.getter(BackupJobSummary::region)).setter(BackupJobSummary.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(BackupJobSummary.getter(BackupJobSummary::accountId)).setter(BackupJobSummary.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(BackupJobSummary.getter(BackupJobSummary::stateAsString)).setter(BackupJobSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(BackupJobSummary.getter(BackupJobSummary::resourceType)).setter(BackupJobSummary.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> MESSAGE_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageCategory").getter(BackupJobSummary.getter(BackupJobSummary::messageCategory)).setter(BackupJobSummary.setter(Builder::messageCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageCategory").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(BackupJobSummary.getter(BackupJobSummary::count)).setter(BackupJobSummary.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(BackupJobSummary.getter(BackupJobSummary::startTime)).setter(BackupJobSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(BackupJobSummary.getter(BackupJobSummary::endTime)).setter(BackupJobSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, ACCOUNT_ID_FIELD, STATE_FIELD, RESOURCE_TYPE_FIELD, MESSAGE_CATEGORY_FIELD, COUNT_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BackupJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String region;
    private final String accountId;
    private final String state;
    private final String resourceType;
    private final String messageCategory;
    private final Integer count;
    private final Instant startTime;
    private final Instant endTime;

    private BackupJobSummary(BuilderImpl builder) {
        this.region = builder.region;
        this.accountId = builder.accountId;
        this.state = builder.state;
        this.resourceType = builder.resourceType;
        this.messageCategory = builder.messageCategory;
        this.count = builder.count;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final String region() {
        return this.region;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final BackupJobStatus state() {
        return BackupJobStatus.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String messageCategory() {
        return this.messageCategory;
    }

    public final Integer count() {
        return this.count;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageCategory());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupJobSummary)) {
            return false;
        }
        BackupJobSummary other = (BackupJobSummary)obj;
        return Objects.equals(this.region(), other.region()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.messageCategory(), other.messageCategory()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"BackupJobSummary").add("Region", (Object)this.region()).add("AccountId", (Object)this.accountId()).add("State", (Object)this.stateAsString()).add("ResourceType", (Object)this.resourceType()).add("MessageCategory", (Object)this.messageCategory()).add("Count", (Object)this.count()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "MessageCategory": {
                return Optional.ofNullable(clazz.cast(this.messageCategory()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Region", REGION_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("MessageCategory", MESSAGE_CATEGORY_FIELD);
        map.put("Count", COUNT_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BackupJobSummary, T> g) {
        return obj -> g.apply((BackupJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private String accountId;
        private String state;
        private String resourceType;
        private String messageCategory;
        private Integer count;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupJobSummary model) {
            this.region(model.region);
            this.accountId(model.accountId);
            this.state(model.state);
            this.resourceType(model.resourceType);
            this.messageCategory(model.messageCategory);
            this.count(model.count);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(BackupJobStatus state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getMessageCategory() {
            return this.messageCategory;
        }

        public final void setMessageCategory(String messageCategory) {
            this.messageCategory = messageCategory;
        }

        @Override
        public final Builder messageCategory(String messageCategory) {
            this.messageCategory = messageCategory;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public BackupJobSummary build() {
            return new BackupJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackupJobSummary> {
        public Builder region(String var1);

        public Builder accountId(String var1);

        public Builder state(String var1);

        public Builder state(BackupJobStatus var1);

        public Builder resourceType(String var1);

        public Builder messageCategory(String var1);

        public Builder count(Integer var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

