/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecoveryPointRestoreMetadataRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, GetRecoveryPointRestoreMetadataRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(GetRecoveryPointRestoreMetadataRequest.getter(GetRecoveryPointRestoreMetadataRequest::backupVaultName)).setter(GetRecoveryPointRestoreMetadataRequest.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()}).build();
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(GetRecoveryPointRestoreMetadataRequest.getter(GetRecoveryPointRestoreMetadataRequest::recoveryPointArn)).setter(GetRecoveryPointRestoreMetadataRequest.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("recoveryPointArn").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultAccountId").getter(GetRecoveryPointRestoreMetadataRequest.getter(GetRecoveryPointRestoreMetadataRequest::backupVaultAccountId)).setter(GetRecoveryPointRestoreMetadataRequest.setter(Builder::backupVaultAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("backupVaultAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD, RECOVERY_POINT_ARN_FIELD, BACKUP_VAULT_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRecoveryPointRestoreMetadataRequest.memberNameToFieldInitializer();
    private final String backupVaultName;
    private final String recoveryPointArn;
    private final String backupVaultAccountId;

    private GetRecoveryPointRestoreMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.backupVaultAccountId = builder.backupVaultAccountId;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final String backupVaultAccountId() {
        return this.backupVaultAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecoveryPointRestoreMetadataRequest)) {
            return false;
        }
        GetRecoveryPointRestoreMetadataRequest other = (GetRecoveryPointRestoreMetadataRequest)((Object)obj);
        return Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.backupVaultAccountId(), other.backupVaultAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecoveryPointRestoreMetadataRequest").add("BackupVaultName", (Object)this.backupVaultName()).add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("BackupVaultAccountId", (Object)this.backupVaultAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "BackupVaultAccountId": {
                return Optional.ofNullable(clazz.cast(this.backupVaultAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("backupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("recoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("backupVaultAccountId", BACKUP_VAULT_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecoveryPointRestoreMetadataRequest, T> g) {
        return obj -> g.apply((GetRecoveryPointRestoreMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String backupVaultName;
        private String recoveryPointArn;
        private String backupVaultAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecoveryPointRestoreMetadataRequest model) {
            super(model);
            this.backupVaultName(model.backupVaultName);
            this.recoveryPointArn(model.recoveryPointArn);
            this.backupVaultAccountId(model.backupVaultAccountId);
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getBackupVaultAccountId() {
            return this.backupVaultAccountId;
        }

        public final void setBackupVaultAccountId(String backupVaultAccountId) {
            this.backupVaultAccountId = backupVaultAccountId;
        }

        @Override
        public final Builder backupVaultAccountId(String backupVaultAccountId) {
            this.backupVaultAccountId = backupVaultAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRecoveryPointRestoreMetadataRequest build() {
            return new GetRecoveryPointRestoreMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecoveryPointRestoreMetadataRequest> {
        public Builder backupVaultName(String var1);

        public Builder recoveryPointArn(String var1);

        public Builder backupVaultAccountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

