/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse;

public class ListBackupSelectionsPublisher
implements SdkPublisher<ListBackupSelectionsResponse> {
    private final BackupAsyncClient client;
    private final ListBackupSelectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBackupSelectionsPublisher(BackupAsyncClient client, ListBackupSelectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBackupSelectionsPublisher(BackupAsyncClient client, ListBackupSelectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBackupSelectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBackupSelectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListBackupSelectionsPublisher resume(ListBackupSelectionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListBackupSelectionsPublisher(this.client, (ListBackupSelectionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListBackupSelectionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListBackupSelectionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListBackupSelectionsResponseFetcher
    implements AsyncPageFetcher<ListBackupSelectionsResponse> {
        private ListBackupSelectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupSelectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBackupSelectionsResponse> nextPage(ListBackupSelectionsResponse previousPage) {
            if (previousPage == null) {
                return ListBackupSelectionsPublisher.this.client.listBackupSelections(ListBackupSelectionsPublisher.this.firstRequest);
            }
            return ListBackupSelectionsPublisher.this.client.listBackupSelections((ListBackupSelectionsRequest)((Object)ListBackupSelectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

