/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.RestoreJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRestoreJobsByProtectedResourceRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, ListRestoreJobsByProtectedResourceRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(ListRestoreJobsByProtectedResourceRequest.getter(ListRestoreJobsByProtectedResourceRequest::resourceArn)).setter(ListRestoreJobsByProtectedResourceRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceArn").build()}).build();
    private static final SdkField<String> BY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByStatus").getter(ListRestoreJobsByProtectedResourceRequest.getter(ListRestoreJobsByProtectedResourceRequest::byStatusAsString)).setter(ListRestoreJobsByProtectedResourceRequest.setter(Builder::byStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final SdkField<Instant> BY_RECOVERY_POINT_CREATION_DATE_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ByRecoveryPointCreationDateAfter").getter(ListRestoreJobsByProtectedResourceRequest.getter(ListRestoreJobsByProtectedResourceRequest::byRecoveryPointCreationDateAfter)).setter(ListRestoreJobsByProtectedResourceRequest.setter(Builder::byRecoveryPointCreationDateAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recoveryPointCreationDateAfter").build()}).build();
    private static final SdkField<Instant> BY_RECOVERY_POINT_CREATION_DATE_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ByRecoveryPointCreationDateBefore").getter(ListRestoreJobsByProtectedResourceRequest.getter(ListRestoreJobsByProtectedResourceRequest::byRecoveryPointCreationDateBefore)).setter(ListRestoreJobsByProtectedResourceRequest.setter(Builder::byRecoveryPointCreationDateBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recoveryPointCreationDateBefore").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRestoreJobsByProtectedResourceRequest.getter(ListRestoreJobsByProtectedResourceRequest::nextToken)).setter(ListRestoreJobsByProtectedResourceRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListRestoreJobsByProtectedResourceRequest.getter(ListRestoreJobsByProtectedResourceRequest::maxResults)).setter(ListRestoreJobsByProtectedResourceRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, BY_STATUS_FIELD, BY_RECOVERY_POINT_CREATION_DATE_AFTER_FIELD, BY_RECOVERY_POINT_CREATION_DATE_BEFORE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRestoreJobsByProtectedResourceRequest.memberNameToFieldInitializer();
    private final String resourceArn;
    private final String byStatus;
    private final Instant byRecoveryPointCreationDateAfter;
    private final Instant byRecoveryPointCreationDateBefore;
    private final String nextToken;
    private final Integer maxResults;

    private ListRestoreJobsByProtectedResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.byStatus = builder.byStatus;
        this.byRecoveryPointCreationDateAfter = builder.byRecoveryPointCreationDateAfter;
        this.byRecoveryPointCreationDateBefore = builder.byRecoveryPointCreationDateBefore;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final RestoreJobStatus byStatus() {
        return RestoreJobStatus.fromValue(this.byStatus);
    }

    public final String byStatusAsString() {
        return this.byStatus;
    }

    public final Instant byRecoveryPointCreationDateAfter() {
        return this.byRecoveryPointCreationDateAfter;
    }

    public final Instant byRecoveryPointCreationDateBefore() {
        return this.byRecoveryPointCreationDateBefore;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.byStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.byRecoveryPointCreationDateAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.byRecoveryPointCreationDateBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRestoreJobsByProtectedResourceRequest)) {
            return false;
        }
        ListRestoreJobsByProtectedResourceRequest other = (ListRestoreJobsByProtectedResourceRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.byStatusAsString(), other.byStatusAsString()) && Objects.equals(this.byRecoveryPointCreationDateAfter(), other.byRecoveryPointCreationDateAfter()) && Objects.equals(this.byRecoveryPointCreationDateBefore(), other.byRecoveryPointCreationDateBefore()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListRestoreJobsByProtectedResourceRequest").add("ResourceArn", (Object)this.resourceArn()).add("ByStatus", (Object)this.byStatusAsString()).add("ByRecoveryPointCreationDateAfter", (Object)this.byRecoveryPointCreationDateAfter()).add("ByRecoveryPointCreationDateBefore", (Object)this.byRecoveryPointCreationDateBefore()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ByStatus": {
                return Optional.ofNullable(clazz.cast(this.byStatusAsString()));
            }
            case "ByRecoveryPointCreationDateAfter": {
                return Optional.ofNullable(clazz.cast(this.byRecoveryPointCreationDateAfter()));
            }
            case "ByRecoveryPointCreationDateBefore": {
                return Optional.ofNullable(clazz.cast(this.byRecoveryPointCreationDateBefore()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("status", BY_STATUS_FIELD);
        map.put("recoveryPointCreationDateAfter", BY_RECOVERY_POINT_CREATION_DATE_AFTER_FIELD);
        map.put("recoveryPointCreationDateBefore", BY_RECOVERY_POINT_CREATION_DATE_BEFORE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRestoreJobsByProtectedResourceRequest, T> g) {
        return obj -> g.apply((ListRestoreJobsByProtectedResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private String byStatus;
        private Instant byRecoveryPointCreationDateAfter;
        private Instant byRecoveryPointCreationDateBefore;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRestoreJobsByProtectedResourceRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.byStatus(model.byStatus);
            this.byRecoveryPointCreationDateAfter(model.byRecoveryPointCreationDateAfter);
            this.byRecoveryPointCreationDateBefore(model.byRecoveryPointCreationDateBefore);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getByStatus() {
            return this.byStatus;
        }

        public final void setByStatus(String byStatus) {
            this.byStatus = byStatus;
        }

        @Override
        public final Builder byStatus(String byStatus) {
            this.byStatus = byStatus;
            return this;
        }

        @Override
        public final Builder byStatus(RestoreJobStatus byStatus) {
            this.byStatus(byStatus == null ? null : byStatus.toString());
            return this;
        }

        public final Instant getByRecoveryPointCreationDateAfter() {
            return this.byRecoveryPointCreationDateAfter;
        }

        public final void setByRecoveryPointCreationDateAfter(Instant byRecoveryPointCreationDateAfter) {
            this.byRecoveryPointCreationDateAfter = byRecoveryPointCreationDateAfter;
        }

        @Override
        public final Builder byRecoveryPointCreationDateAfter(Instant byRecoveryPointCreationDateAfter) {
            this.byRecoveryPointCreationDateAfter = byRecoveryPointCreationDateAfter;
            return this;
        }

        public final Instant getByRecoveryPointCreationDateBefore() {
            return this.byRecoveryPointCreationDateBefore;
        }

        public final void setByRecoveryPointCreationDateBefore(Instant byRecoveryPointCreationDateBefore) {
            this.byRecoveryPointCreationDateBefore = byRecoveryPointCreationDateBefore;
        }

        @Override
        public final Builder byRecoveryPointCreationDateBefore(Instant byRecoveryPointCreationDateBefore) {
            this.byRecoveryPointCreationDateBefore = byRecoveryPointCreationDateBefore;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRestoreJobsByProtectedResourceRequest build() {
            return new ListRestoreJobsByProtectedResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRestoreJobsByProtectedResourceRequest> {
        public Builder resourceArn(String var1);

        public Builder byStatus(String var1);

        public Builder byStatus(RestoreJobStatus var1);

        public Builder byRecoveryPointCreationDateAfter(Instant var1);

        public Builder byRecoveryPointCreationDateBefore(Instant var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

