/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.RestoreTestingPlanForCreate;
import software.amazon.awssdk.services.backup.model.SensitiveStringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRestoreTestingPlanRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, CreateRestoreTestingPlanRequest> {
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(CreateRestoreTestingPlanRequest.getter(CreateRestoreTestingPlanRequest::creatorRequestId)).setter(CreateRestoreTestingPlanRequest.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<RestoreTestingPlanForCreate> RESTORE_TESTING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RestoreTestingPlan").getter(CreateRestoreTestingPlanRequest.getter(CreateRestoreTestingPlanRequest::restoreTestingPlan)).setter(CreateRestoreTestingPlanRequest.setter(Builder::restoreTestingPlan)).constructor(RestoreTestingPlanForCreate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlan").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateRestoreTestingPlanRequest.getter(CreateRestoreTestingPlanRequest::tags)).setter(CreateRestoreTestingPlanRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATOR_REQUEST_ID_FIELD, RESTORE_TESTING_PLAN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRestoreTestingPlanRequest.memberNameToFieldInitializer();
    private final String creatorRequestId;
    private final RestoreTestingPlanForCreate restoreTestingPlan;
    private final Map<String, String> tags;

    private CreateRestoreTestingPlanRequest(BuilderImpl builder) {
        super(builder);
        this.creatorRequestId = builder.creatorRequestId;
        this.restoreTestingPlan = builder.restoreTestingPlan;
        this.tags = builder.tags;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final RestoreTestingPlanForCreate restoreTestingPlan() {
        return this.restoreTestingPlan;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreTestingPlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestoreTestingPlanRequest)) {
            return false;
        }
        CreateRestoreTestingPlanRequest other = (CreateRestoreTestingPlanRequest)((Object)obj);
        return Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.restoreTestingPlan(), other.restoreTestingPlan()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRestoreTestingPlanRequest").add("CreatorRequestId", (Object)this.creatorRequestId()).add("RestoreTestingPlan", (Object)this.restoreTestingPlan()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "RestoreTestingPlan": {
                return Optional.ofNullable(clazz.cast(this.restoreTestingPlan()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("RestoreTestingPlan", RESTORE_TESTING_PLAN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRestoreTestingPlanRequest, T> g) {
        return obj -> g.apply((CreateRestoreTestingPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String creatorRequestId;
        private RestoreTestingPlanForCreate restoreTestingPlan;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestoreTestingPlanRequest model) {
            super(model);
            this.creatorRequestId(model.creatorRequestId);
            this.restoreTestingPlan(model.restoreTestingPlan);
            this.tags(model.tags);
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final RestoreTestingPlanForCreate.Builder getRestoreTestingPlan() {
            return this.restoreTestingPlan != null ? this.restoreTestingPlan.toBuilder() : null;
        }

        public final void setRestoreTestingPlan(RestoreTestingPlanForCreate.BuilderImpl restoreTestingPlan) {
            this.restoreTestingPlan = restoreTestingPlan != null ? restoreTestingPlan.build() : null;
        }

        @Override
        public final Builder restoreTestingPlan(RestoreTestingPlanForCreate restoreTestingPlan) {
            this.restoreTestingPlan = restoreTestingPlan;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = SensitiveStringMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = SensitiveStringMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRestoreTestingPlanRequest build() {
            return new CreateRestoreTestingPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRestoreTestingPlanRequest> {
        public Builder creatorRequestId(String var1);

        public Builder restoreTestingPlan(RestoreTestingPlanForCreate var1);

        default public Builder restoreTestingPlan(Consumer<RestoreTestingPlanForCreate.Builder> restoreTestingPlan) {
            return this.restoreTestingPlan((RestoreTestingPlanForCreate)((RestoreTestingPlanForCreate.Builder)RestoreTestingPlanForCreate.builder().applyMutation(restoreTestingPlan)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

