/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.ReportPlan;
import software.amazon.awssdk.services.backup.model.ReportPlanListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReportPlansResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListReportPlansResponse> {
    private static final SdkField<List<ReportPlan>> REPORT_PLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReportPlans").getter(ListReportPlansResponse.getter(ListReportPlansResponse::reportPlans)).setter(ListReportPlansResponse.setter(Builder::reportPlans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReportPlan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListReportPlansResponse.getter(ListReportPlansResponse::nextToken)).setter(ListReportPlansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_PLANS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReportPlans", REPORT_PLANS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ReportPlan> reportPlans;
    private final String nextToken;

    private ListReportPlansResponse(BuilderImpl builder) {
        super(builder);
        this.reportPlans = builder.reportPlans;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReportPlans() {
        return this.reportPlans != null && !(this.reportPlans instanceof SdkAutoConstructList);
    }

    public final List<ReportPlan> reportPlans() {
        return this.reportPlans;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportPlans() ? this.reportPlans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportPlansResponse)) {
            return false;
        }
        ListReportPlansResponse other = (ListReportPlansResponse)((Object)obj);
        return this.hasReportPlans() == other.hasReportPlans() && Objects.equals(this.reportPlans(), other.reportPlans()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListReportPlansResponse").add("ReportPlans", this.hasReportPlans() ? this.reportPlans() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportPlans": {
                return Optional.ofNullable(clazz.cast(this.reportPlans()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListReportPlansResponse, T> g) {
        return obj -> g.apply((ListReportPlansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private List<ReportPlan> reportPlans = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReportPlansResponse model) {
            super(model);
            this.reportPlans(model.reportPlans);
            this.nextToken(model.nextToken);
        }

        public final List<ReportPlan.Builder> getReportPlans() {
            List<ReportPlan.Builder> result = ReportPlanListCopier.copyToBuilder(this.reportPlans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReportPlans(Collection<ReportPlan.BuilderImpl> reportPlans) {
            this.reportPlans = ReportPlanListCopier.copyFromBuilder(reportPlans);
        }

        @Override
        public final Builder reportPlans(Collection<ReportPlan> reportPlans) {
            this.reportPlans = ReportPlanListCopier.copy(reportPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportPlans(ReportPlan ... reportPlans) {
            this.reportPlans(Arrays.asList(reportPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportPlans(Consumer<ReportPlan.Builder> ... reportPlans) {
            this.reportPlans(Stream.of(reportPlans).map(c -> (ReportPlan)((ReportPlan.Builder)ReportPlan.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReportPlansResponse build() {
            return new ListReportPlansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReportPlansResponse> {
        public Builder reportPlans(Collection<ReportPlan> var1);

        public Builder reportPlans(ReportPlan ... var1);

        public Builder reportPlans(Consumer<ReportPlan.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

