/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.RestoreTestingPlanForList;
import software.amazon.awssdk.services.backup.model.RestoreTestingPlansCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRestoreTestingPlansResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListRestoreTestingPlansResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRestoreTestingPlansResponse.getter(ListRestoreTestingPlansResponse::nextToken)).setter(ListRestoreTestingPlansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RestoreTestingPlanForList>> RESTORE_TESTING_PLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RestoreTestingPlans").getter(ListRestoreTestingPlansResponse.getter(ListRestoreTestingPlansResponse::restoreTestingPlans)).setter(ListRestoreTestingPlansResponse.setter(Builder::restoreTestingPlans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RestoreTestingPlanForList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESTORE_TESTING_PLANS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("RestoreTestingPlans", RESTORE_TESTING_PLANS_FIELD);
        }
    });
    private final String nextToken;
    private final List<RestoreTestingPlanForList> restoreTestingPlans;

    private ListRestoreTestingPlansResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.restoreTestingPlans = builder.restoreTestingPlans;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRestoreTestingPlans() {
        return this.restoreTestingPlans != null && !(this.restoreTestingPlans instanceof SdkAutoConstructList);
    }

    public final List<RestoreTestingPlanForList> restoreTestingPlans() {
        return this.restoreTestingPlans;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRestoreTestingPlans() ? this.restoreTestingPlans() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRestoreTestingPlansResponse)) {
            return false;
        }
        ListRestoreTestingPlansResponse other = (ListRestoreTestingPlansResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRestoreTestingPlans() == other.hasRestoreTestingPlans() && Objects.equals(this.restoreTestingPlans(), other.restoreTestingPlans());
    }

    public final String toString() {
        return ToString.builder((String)"ListRestoreTestingPlansResponse").add("NextToken", (Object)this.nextToken()).add("RestoreTestingPlans", this.hasRestoreTestingPlans() ? this.restoreTestingPlans() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RestoreTestingPlans": {
                return Optional.ofNullable(clazz.cast(this.restoreTestingPlans()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRestoreTestingPlansResponse, T> g) {
        return obj -> g.apply((ListRestoreTestingPlansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RestoreTestingPlanForList> restoreTestingPlans = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRestoreTestingPlansResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.restoreTestingPlans(model.restoreTestingPlans);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RestoreTestingPlanForList.Builder> getRestoreTestingPlans() {
            List<RestoreTestingPlanForList.Builder> result = RestoreTestingPlansCopier.copyToBuilder(this.restoreTestingPlans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRestoreTestingPlans(Collection<RestoreTestingPlanForList.BuilderImpl> restoreTestingPlans) {
            this.restoreTestingPlans = RestoreTestingPlansCopier.copyFromBuilder(restoreTestingPlans);
        }

        @Override
        public final Builder restoreTestingPlans(Collection<RestoreTestingPlanForList> restoreTestingPlans) {
            this.restoreTestingPlans = RestoreTestingPlansCopier.copy(restoreTestingPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreTestingPlans(RestoreTestingPlanForList ... restoreTestingPlans) {
            this.restoreTestingPlans(Arrays.asList(restoreTestingPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreTestingPlans(Consumer<RestoreTestingPlanForList.Builder> ... restoreTestingPlans) {
            this.restoreTestingPlans(Stream.of(restoreTestingPlans).map(c -> (RestoreTestingPlanForList)((RestoreTestingPlanForList.Builder)RestoreTestingPlanForList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRestoreTestingPlansResponse build() {
            return new ListRestoreTestingPlansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRestoreTestingPlansResponse> {
        public Builder nextToken(String var1);

        public Builder restoreTestingPlans(Collection<RestoreTestingPlanForList> var1);

        public Builder restoreTestingPlans(RestoreTestingPlanForList ... var1);

        public Builder restoreTestingPlans(Consumer<RestoreTestingPlanForList.Builder> ... var1);
    }
}

