/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CopyJobStatus {
    CREATED("CREATED"),
    RUNNING("RUNNING"),
    ABORTING("ABORTING"),
    ABORTED("ABORTED"),
    COMPLETING("COMPLETING"),
    COMPLETED("COMPLETED"),
    FAILING("FAILING"),
    FAILED("FAILED"),
    PARTIAL("PARTIAL"),
    AGGREGATE_ALL("AGGREGATE_ALL"),
    ANY("ANY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CopyJobStatus> VALUE_MAP;
    private final String value;

    private CopyJobStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CopyJobStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CopyJobStatus> knownValues() {
        EnumSet<CopyJobStatus> knownValues = EnumSet.allOf(CopyJobStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CopyJobStatus.class, CopyJobStatus::toString);
    }
}

