/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBackupVaultRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, DescribeBackupVaultRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(DescribeBackupVaultRequest.getter(DescribeBackupVaultRequest::backupVaultName)).setter(DescribeBackupVaultRequest.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultAccountId").getter(DescribeBackupVaultRequest.getter(DescribeBackupVaultRequest::backupVaultAccountId)).setter(DescribeBackupVaultRequest.setter(Builder::backupVaultAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("backupVaultAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD, BACKUP_VAULT_ACCOUNT_ID_FIELD));
    private final String backupVaultName;
    private final String backupVaultAccountId;

    private DescribeBackupVaultRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultAccountId = builder.backupVaultAccountId;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final String backupVaultAccountId() {
        return this.backupVaultAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBackupVaultRequest)) {
            return false;
        }
        DescribeBackupVaultRequest other = (DescribeBackupVaultRequest)((Object)obj);
        return Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.backupVaultAccountId(), other.backupVaultAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBackupVaultRequest").add("BackupVaultName", (Object)this.backupVaultName()).add("BackupVaultAccountId", (Object)this.backupVaultAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "BackupVaultAccountId": {
                return Optional.ofNullable(clazz.cast(this.backupVaultAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBackupVaultRequest, T> g) {
        return obj -> g.apply((DescribeBackupVaultRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String backupVaultName;
        private String backupVaultAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBackupVaultRequest model) {
            super(model);
            this.backupVaultName(model.backupVaultName);
            this.backupVaultAccountId(model.backupVaultAccountId);
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getBackupVaultAccountId() {
            return this.backupVaultAccountId;
        }

        public final void setBackupVaultAccountId(String backupVaultAccountId) {
            this.backupVaultAccountId = backupVaultAccountId;
        }

        @Override
        public final Builder backupVaultAccountId(String backupVaultAccountId) {
            this.backupVaultAccountId = backupVaultAccountId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeBackupVaultRequest build() {
            return new DescribeBackupVaultRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBackupVaultRequest> {
        public Builder backupVaultName(String var1);

        public Builder backupVaultAccountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

