/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model._stringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRestoreTestingInferredMetadataResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, GetRestoreTestingInferredMetadataResponse> {
    private static final SdkField<Map<String, String>> INFERRED_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("InferredMetadata").getter(GetRestoreTestingInferredMetadataResponse.getter(GetRestoreTestingInferredMetadataResponse::inferredMetadata)).setter(GetRestoreTestingInferredMetadataResponse.setter(Builder::inferredMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferredMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERRED_METADATA_FIELD));
    private final Map<String, String> inferredMetadata;

    private GetRestoreTestingInferredMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.inferredMetadata = builder.inferredMetadata;
    }

    public final boolean hasInferredMetadata() {
        return this.inferredMetadata != null && !(this.inferredMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> inferredMetadata() {
        return this.inferredMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferredMetadata() ? this.inferredMetadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRestoreTestingInferredMetadataResponse)) {
            return false;
        }
        GetRestoreTestingInferredMetadataResponse other = (GetRestoreTestingInferredMetadataResponse)((Object)obj);
        return this.hasInferredMetadata() == other.hasInferredMetadata() && Objects.equals(this.inferredMetadata(), other.inferredMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"GetRestoreTestingInferredMetadataResponse").add("InferredMetadata", this.hasInferredMetadata() ? this.inferredMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InferredMetadata": {
                return Optional.ofNullable(clazz.cast(this.inferredMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRestoreTestingInferredMetadataResponse, T> g) {
        return obj -> g.apply((GetRestoreTestingInferredMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private Map<String, String> inferredMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRestoreTestingInferredMetadataResponse model) {
            super(model);
            this.inferredMetadata(model.inferredMetadata);
        }

        public final Map<String, String> getInferredMetadata() {
            if (this.inferredMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.inferredMetadata;
        }

        public final void setInferredMetadata(Map<String, String> inferredMetadata) {
            this.inferredMetadata = _stringMapCopier.copy(inferredMetadata);
        }

        @Override
        public final Builder inferredMetadata(Map<String, String> inferredMetadata) {
            this.inferredMetadata = _stringMapCopier.copy(inferredMetadata);
            return this;
        }

        @Override
        public GetRestoreTestingInferredMetadataResponse build() {
            return new GetRestoreTestingInferredMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRestoreTestingInferredMetadataResponse> {
        public Builder inferredMetadata(Map<String, String> var1);
    }
}

