/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.ControlInputParameter;
import software.amazon.awssdk.services.backup.model.ControlInputParametersCopier;
import software.amazon.awssdk.services.backup.model.ControlScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FrameworkControl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FrameworkControl> {
    private static final SdkField<String> CONTROL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlName").getter(FrameworkControl.getter(FrameworkControl::controlName)).setter(FrameworkControl.setter(Builder::controlName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlName").build()}).build();
    private static final SdkField<List<ControlInputParameter>> CONTROL_INPUT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ControlInputParameters").getter(FrameworkControl.getter(FrameworkControl::controlInputParameters)).setter(FrameworkControl.setter(Builder::controlInputParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlInputParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ControlInputParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ControlScope> CONTROL_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ControlScope").getter(FrameworkControl.getter(FrameworkControl::controlScope)).setter(FrameworkControl.setter(Builder::controlScope)).constructor(ControlScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_NAME_FIELD, CONTROL_INPUT_PARAMETERS_FIELD, CONTROL_SCOPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String controlName;
    private final List<ControlInputParameter> controlInputParameters;
    private final ControlScope controlScope;

    private FrameworkControl(BuilderImpl builder) {
        this.controlName = builder.controlName;
        this.controlInputParameters = builder.controlInputParameters;
        this.controlScope = builder.controlScope;
    }

    public final String controlName() {
        return this.controlName;
    }

    public final boolean hasControlInputParameters() {
        return this.controlInputParameters != null && !(this.controlInputParameters instanceof SdkAutoConstructList);
    }

    public final List<ControlInputParameter> controlInputParameters() {
        return this.controlInputParameters;
    }

    public final ControlScope controlScope() {
        return this.controlScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.controlName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlInputParameters() ? this.controlInputParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.controlScope());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameworkControl)) {
            return false;
        }
        FrameworkControl other = (FrameworkControl)obj;
        return Objects.equals(this.controlName(), other.controlName()) && this.hasControlInputParameters() == other.hasControlInputParameters() && Objects.equals(this.controlInputParameters(), other.controlInputParameters()) && Objects.equals(this.controlScope(), other.controlScope());
    }

    public final String toString() {
        return ToString.builder((String)"FrameworkControl").add("ControlName", (Object)this.controlName()).add("ControlInputParameters", this.hasControlInputParameters() ? this.controlInputParameters() : null).add("ControlScope", (Object)this.controlScope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ControlName": {
                return Optional.ofNullable(clazz.cast(this.controlName()));
            }
            case "ControlInputParameters": {
                return Optional.ofNullable(clazz.cast(this.controlInputParameters()));
            }
            case "ControlScope": {
                return Optional.ofNullable(clazz.cast(this.controlScope()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FrameworkControl, T> g) {
        return obj -> g.apply((FrameworkControl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String controlName;
        private List<ControlInputParameter> controlInputParameters = DefaultSdkAutoConstructList.getInstance();
        private ControlScope controlScope;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameworkControl model) {
            this.controlName(model.controlName);
            this.controlInputParameters(model.controlInputParameters);
            this.controlScope(model.controlScope);
        }

        public final String getControlName() {
            return this.controlName;
        }

        public final void setControlName(String controlName) {
            this.controlName = controlName;
        }

        @Override
        public final Builder controlName(String controlName) {
            this.controlName = controlName;
            return this;
        }

        public final List<ControlInputParameter.Builder> getControlInputParameters() {
            List<ControlInputParameter.Builder> result = ControlInputParametersCopier.copyToBuilder(this.controlInputParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlInputParameters(Collection<ControlInputParameter.BuilderImpl> controlInputParameters) {
            this.controlInputParameters = ControlInputParametersCopier.copyFromBuilder(controlInputParameters);
        }

        @Override
        public final Builder controlInputParameters(Collection<ControlInputParameter> controlInputParameters) {
            this.controlInputParameters = ControlInputParametersCopier.copy(controlInputParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlInputParameters(ControlInputParameter ... controlInputParameters) {
            this.controlInputParameters(Arrays.asList(controlInputParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlInputParameters(Consumer<ControlInputParameter.Builder> ... controlInputParameters) {
            this.controlInputParameters(Stream.of(controlInputParameters).map(c -> (ControlInputParameter)((ControlInputParameter.Builder)ControlInputParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ControlScope.Builder getControlScope() {
            return this.controlScope != null ? this.controlScope.toBuilder() : null;
        }

        public final void setControlScope(ControlScope.BuilderImpl controlScope) {
            this.controlScope = controlScope != null ? controlScope.build() : null;
        }

        @Override
        public final Builder controlScope(ControlScope controlScope) {
            this.controlScope = controlScope;
            return this;
        }

        public FrameworkControl build() {
            return new FrameworkControl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FrameworkControl> {
        public Builder controlName(String var1);

        public Builder controlInputParameters(Collection<ControlInputParameter> var1);

        public Builder controlInputParameters(ControlInputParameter ... var1);

        public Builder controlInputParameters(Consumer<ControlInputParameter.Builder> ... var1);

        public Builder controlScope(ControlScope var1);

        default public Builder controlScope(Consumer<ControlScope.Builder> controlScope) {
            return this.controlScope((ControlScope)((ControlScope.Builder)ControlScope.builder().applyMutation(controlScope)).build());
        }
    }
}

