/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse;
import software.amazon.awssdk.services.backup.model.RestoreJobsListMember;

public class ListRestoreJobsIterable
implements SdkIterable<ListRestoreJobsResponse> {
    private final BackupClient client;
    private final ListRestoreJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRestoreJobsIterable(BackupClient client, ListRestoreJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRestoreJobsResponseFetcher();
    }

    public Iterator<ListRestoreJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RestoreJobsListMember> restoreJobs() {
        Function<ListRestoreJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.restoreJobs() != null) {
                return response.restoreJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRestoreJobsResponseFetcher
    implements SyncPageFetcher<ListRestoreJobsResponse> {
        private ListRestoreJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListRestoreJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRestoreJobsResponse nextPage(ListRestoreJobsResponse previousPage) {
            if (previousPage == null) {
                return ListRestoreJobsIterable.this.client.listRestoreJobs(ListRestoreJobsIterable.this.firstRequest);
            }
            return ListRestoreJobsIterable.this.client.listRestoreJobs((ListRestoreJobsRequest)((Object)ListRestoreJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

