/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.BackupPlanTemplatesListMember;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse;

public class ListBackupPlanTemplatesIterable
implements SdkIterable<ListBackupPlanTemplatesResponse> {
    private final BackupClient client;
    private final ListBackupPlanTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBackupPlanTemplatesIterable(BackupClient client, ListBackupPlanTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBackupPlanTemplatesResponseFetcher();
    }

    public Iterator<ListBackupPlanTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BackupPlanTemplatesListMember> backupPlanTemplatesList() {
        Function<ListBackupPlanTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.backupPlanTemplatesList() != null) {
                return response.backupPlanTemplatesList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBackupPlanTemplatesResponseFetcher
    implements SyncPageFetcher<ListBackupPlanTemplatesResponse> {
        private ListBackupPlanTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupPlanTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBackupPlanTemplatesResponse nextPage(ListBackupPlanTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListBackupPlanTemplatesIterable.this.client.listBackupPlanTemplates(ListBackupPlanTemplatesIterable.this.firstRequest);
            }
            return ListBackupPlanTemplatesIterable.this.client.listBackupPlanTemplates((ListBackupPlanTemplatesRequest)((Object)ListBackupPlanTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

