/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldResponse;
import software.amazon.awssdk.services.backup.model.RecoveryPointMember;

public class ListRecoveryPointsByLegalHoldIterable
implements SdkIterable<ListRecoveryPointsByLegalHoldResponse> {
    private final BackupClient client;
    private final ListRecoveryPointsByLegalHoldRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecoveryPointsByLegalHoldIterable(BackupClient client, ListRecoveryPointsByLegalHoldRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRecoveryPointsByLegalHoldResponseFetcher();
    }

    public Iterator<ListRecoveryPointsByLegalHoldResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecoveryPointMember> recoveryPoints() {
        Function<ListRecoveryPointsByLegalHoldResponse, Iterator> getIterator = response -> {
            if (response != null && response.recoveryPoints() != null) {
                return response.recoveryPoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecoveryPointsByLegalHoldResponseFetcher
    implements SyncPageFetcher<ListRecoveryPointsByLegalHoldResponse> {
        private ListRecoveryPointsByLegalHoldResponseFetcher() {
        }

        public boolean hasNextPage(ListRecoveryPointsByLegalHoldResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecoveryPointsByLegalHoldResponse nextPage(ListRecoveryPointsByLegalHoldResponse previousPage) {
            if (previousPage == null) {
                return ListRecoveryPointsByLegalHoldIterable.this.client.listRecoveryPointsByLegalHold(ListRecoveryPointsByLegalHoldIterable.this.firstRequest);
            }
            return ListRecoveryPointsByLegalHoldIterable.this.client.listRecoveryPointsByLegalHold((ListRecoveryPointsByLegalHoldRequest)((Object)ListRecoveryPointsByLegalHoldIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

