/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.model.ListFrameworksRequest;
import software.amazon.awssdk.services.backup.model.ListFrameworksResponse;

public class ListFrameworksIterable
implements SdkIterable<ListFrameworksResponse> {
    private final BackupClient client;
    private final ListFrameworksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFrameworksIterable(BackupClient client, ListFrameworksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFrameworksResponseFetcher();
    }

    public Iterator<ListFrameworksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFrameworksResponseFetcher
    implements SyncPageFetcher<ListFrameworksResponse> {
        private ListFrameworksResponseFetcher() {
        }

        public boolean hasNextPage(ListFrameworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFrameworksResponse nextPage(ListFrameworksResponse previousPage) {
            if (previousPage == null) {
                return ListFrameworksIterable.this.client.listFrameworks(ListFrameworksIterable.this.firstRequest);
            }
            return ListFrameworksIterable.this.client.listFrameworks((ListFrameworksRequest)((Object)ListFrameworksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

