/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.DateRange;
import software.amazon.awssdk.services.backup.model.ResourceIdentifiersCopier;
import software.amazon.awssdk.services.backup.model.VaultNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecoveryPointSelection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecoveryPointSelection> {
    private static final SdkField<List<String>> VAULT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VaultNames").getter(RecoveryPointSelection.getter(RecoveryPointSelection::vaultNames)).setter(RecoveryPointSelection.setter(Builder::vaultNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceIdentifiers").getter(RecoveryPointSelection.getter(RecoveryPointSelection::resourceIdentifiers)).setter(RecoveryPointSelection.setter(Builder::resourceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DateRange> DATE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DateRange").getter(RecoveryPointSelection.getter(RecoveryPointSelection::dateRange)).setter(RecoveryPointSelection.setter(Builder::dateRange)).constructor(DateRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VAULT_NAMES_FIELD, RESOURCE_IDENTIFIERS_FIELD, DATE_RANGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> vaultNames;
    private final List<String> resourceIdentifiers;
    private final DateRange dateRange;

    private RecoveryPointSelection(BuilderImpl builder) {
        this.vaultNames = builder.vaultNames;
        this.resourceIdentifiers = builder.resourceIdentifiers;
        this.dateRange = builder.dateRange;
    }

    public final boolean hasVaultNames() {
        return this.vaultNames != null && !(this.vaultNames instanceof SdkAutoConstructList);
    }

    public final List<String> vaultNames() {
        return this.vaultNames;
    }

    public final boolean hasResourceIdentifiers() {
        return this.resourceIdentifiers != null && !(this.resourceIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> resourceIdentifiers() {
        return this.resourceIdentifiers;
    }

    public final DateRange dateRange() {
        return this.dateRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVaultNames() ? this.vaultNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIdentifiers() ? this.resourceIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dateRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryPointSelection)) {
            return false;
        }
        RecoveryPointSelection other = (RecoveryPointSelection)obj;
        return this.hasVaultNames() == other.hasVaultNames() && Objects.equals(this.vaultNames(), other.vaultNames()) && this.hasResourceIdentifiers() == other.hasResourceIdentifiers() && Objects.equals(this.resourceIdentifiers(), other.resourceIdentifiers()) && Objects.equals(this.dateRange(), other.dateRange());
    }

    public final String toString() {
        return ToString.builder((String)"RecoveryPointSelection").add("VaultNames", this.hasVaultNames() ? this.vaultNames() : null).add("ResourceIdentifiers", this.hasResourceIdentifiers() ? this.resourceIdentifiers() : null).add("DateRange", (Object)this.dateRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VaultNames": {
                return Optional.ofNullable(clazz.cast(this.vaultNames()));
            }
            case "ResourceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifiers()));
            }
            case "DateRange": {
                return Optional.ofNullable(clazz.cast(this.dateRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryPointSelection, T> g) {
        return obj -> g.apply((RecoveryPointSelection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> vaultNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private DateRange dateRange;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryPointSelection model) {
            this.vaultNames(model.vaultNames);
            this.resourceIdentifiers(model.resourceIdentifiers);
            this.dateRange(model.dateRange);
        }

        public final Collection<String> getVaultNames() {
            if (this.vaultNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vaultNames;
        }

        public final void setVaultNames(Collection<String> vaultNames) {
            this.vaultNames = VaultNamesCopier.copy(vaultNames);
        }

        @Override
        public final Builder vaultNames(Collection<String> vaultNames) {
            this.vaultNames = VaultNamesCopier.copy(vaultNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vaultNames(String ... vaultNames) {
            this.vaultNames(Arrays.asList(vaultNames));
            return this;
        }

        public final Collection<String> getResourceIdentifiers() {
            if (this.resourceIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceIdentifiers;
        }

        public final void setResourceIdentifiers(Collection<String> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifiersCopier.copy(resourceIdentifiers);
        }

        @Override
        public final Builder resourceIdentifiers(Collection<String> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifiersCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(String ... resourceIdentifiers) {
            this.resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        public final DateRange.Builder getDateRange() {
            return this.dateRange != null ? this.dateRange.toBuilder() : null;
        }

        public final void setDateRange(DateRange.BuilderImpl dateRange) {
            this.dateRange = dateRange != null ? dateRange.build() : null;
        }

        @Override
        public final Builder dateRange(DateRange dateRange) {
            this.dateRange = dateRange;
            return this;
        }

        public RecoveryPointSelection build() {
            return new RecoveryPointSelection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecoveryPointSelection> {
        public Builder vaultNames(Collection<String> var1);

        public Builder vaultNames(String ... var1);

        public Builder resourceIdentifiers(Collection<String> var1);

        public Builder resourceIdentifiers(String ... var1);

        public Builder dateRange(DateRange var1);

        default public Builder dateRange(Consumer<DateRange.Builder> dateRange) {
            return this.dateRange((DateRange)((DateRange.Builder)DateRange.builder().applyMutation(dateRange)).build());
        }
    }
}

