/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse;
import software.amazon.awssdk.services.backup.model.RecoveryPointByResource;

public class ListRecoveryPointsByResourceIterable
implements SdkIterable<ListRecoveryPointsByResourceResponse> {
    private final BackupClient client;
    private final ListRecoveryPointsByResourceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecoveryPointsByResourceIterable(BackupClient client, ListRecoveryPointsByResourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRecoveryPointsByResourceResponseFetcher();
    }

    public Iterator<ListRecoveryPointsByResourceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecoveryPointByResource> recoveryPoints() {
        Function<ListRecoveryPointsByResourceResponse, Iterator> getIterator = response -> {
            if (response != null && response.recoveryPoints() != null) {
                return response.recoveryPoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecoveryPointsByResourceResponseFetcher
    implements SyncPageFetcher<ListRecoveryPointsByResourceResponse> {
        private ListRecoveryPointsByResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListRecoveryPointsByResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecoveryPointsByResourceResponse nextPage(ListRecoveryPointsByResourceResponse previousPage) {
            if (previousPage == null) {
                return ListRecoveryPointsByResourceIterable.this.client.listRecoveryPointsByResource(ListRecoveryPointsByResourceIterable.this.firstRequest);
            }
            return ListRecoveryPointsByResourceIterable.this.client.listRecoveryPointsByResource((ListRecoveryPointsByResourceRequest)((Object)ListRecoveryPointsByResourceIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

