/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.model.BackupJob;
import software.amazon.awssdk.services.backup.model.ListBackupJobsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobsResponse;

public class ListBackupJobsIterable
implements SdkIterable<ListBackupJobsResponse> {
    private final BackupClient client;
    private final ListBackupJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBackupJobsIterable(BackupClient client, ListBackupJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBackupJobsResponseFetcher();
    }

    public Iterator<ListBackupJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BackupJob> backupJobs() {
        Function<ListBackupJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.backupJobs() != null) {
                return response.backupJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBackupJobsResponseFetcher
    implements SyncPageFetcher<ListBackupJobsResponse> {
        private ListBackupJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBackupJobsResponse nextPage(ListBackupJobsResponse previousPage) {
            if (previousPage == null) {
                return ListBackupJobsIterable.this.client.listBackupJobs(ListBackupJobsIterable.this.firstRequest);
            }
            return ListBackupJobsIterable.this.client.listBackupJobs((ListBackupJobsRequest)((Object)ListBackupJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

