/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupPlanVersionsListCopier;
import software.amazon.awssdk.services.backup.model.BackupPlansListMember;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBackupPlanVersionsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListBackupPlanVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBackupPlanVersionsResponse.getter(ListBackupPlanVersionsResponse::nextToken)).setter(ListBackupPlanVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<BackupPlansListMember>> BACKUP_PLAN_VERSIONS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BackupPlanVersionsList").getter(ListBackupPlanVersionsResponse.getter(ListBackupPlanVersionsResponse::backupPlanVersionsList)).setter(ListBackupPlanVersionsResponse.setter(Builder::backupPlanVersionsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanVersionsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackupPlansListMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, BACKUP_PLAN_VERSIONS_LIST_FIELD));
    private final String nextToken;
    private final List<BackupPlansListMember> backupPlanVersionsList;

    private ListBackupPlanVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.backupPlanVersionsList = builder.backupPlanVersionsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasBackupPlanVersionsList() {
        return this.backupPlanVersionsList != null && !(this.backupPlanVersionsList instanceof SdkAutoConstructList);
    }

    public final List<BackupPlansListMember> backupPlanVersionsList() {
        return this.backupPlanVersionsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackupPlanVersionsList() ? this.backupPlanVersionsList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupPlanVersionsResponse)) {
            return false;
        }
        ListBackupPlanVersionsResponse other = (ListBackupPlanVersionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasBackupPlanVersionsList() == other.hasBackupPlanVersionsList() && Objects.equals(this.backupPlanVersionsList(), other.backupPlanVersionsList());
    }

    public final String toString() {
        return ToString.builder((String)"ListBackupPlanVersionsResponse").add("NextToken", (Object)this.nextToken()).add("BackupPlanVersionsList", this.hasBackupPlanVersionsList() ? this.backupPlanVersionsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "BackupPlanVersionsList": {
                return Optional.ofNullable(clazz.cast(this.backupPlanVersionsList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupPlanVersionsResponse, T> g) {
        return obj -> g.apply((ListBackupPlanVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<BackupPlansListMember> backupPlanVersionsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupPlanVersionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.backupPlanVersionsList(model.backupPlanVersionsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BackupPlansListMember.Builder> getBackupPlanVersionsList() {
            List<BackupPlansListMember.Builder> result = BackupPlanVersionsListCopier.copyToBuilder(this.backupPlanVersionsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackupPlanVersionsList(Collection<BackupPlansListMember.BuilderImpl> backupPlanVersionsList) {
            this.backupPlanVersionsList = BackupPlanVersionsListCopier.copyFromBuilder(backupPlanVersionsList);
        }

        @Override
        public final Builder backupPlanVersionsList(Collection<BackupPlansListMember> backupPlanVersionsList) {
            this.backupPlanVersionsList = BackupPlanVersionsListCopier.copy(backupPlanVersionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlanVersionsList(BackupPlansListMember ... backupPlanVersionsList) {
            this.backupPlanVersionsList(Arrays.asList(backupPlanVersionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlanVersionsList(Consumer<BackupPlansListMember.Builder> ... backupPlanVersionsList) {
            this.backupPlanVersionsList(Stream.of(backupPlanVersionsList).map(c -> (BackupPlansListMember)((BackupPlansListMember.Builder)BackupPlansListMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBackupPlanVersionsResponse build() {
            return new ListBackupPlanVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBackupPlanVersionsResponse> {
        public Builder nextToken(String var1);

        public Builder backupPlanVersionsList(Collection<BackupPlansListMember> var1);

        public Builder backupPlanVersionsList(BackupPlansListMember ... var1);

        public Builder backupPlanVersionsList(Consumer<BackupPlansListMember.Builder> ... var1);
    }
}

