/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.model.BackupSelectionsListMember;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse;

public class ListBackupSelectionsPublisher
implements SdkPublisher<ListBackupSelectionsResponse> {
    private final BackupAsyncClient client;
    private final ListBackupSelectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBackupSelectionsPublisher(BackupAsyncClient client, ListBackupSelectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBackupSelectionsPublisher(BackupAsyncClient client, ListBackupSelectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBackupSelectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBackupSelectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BackupSelectionsListMember> backupSelectionsList() {
        Function<ListBackupSelectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.backupSelectionsList() != null) {
                return response.backupSelectionsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBackupSelectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBackupSelectionsResponseFetcher
    implements AsyncPageFetcher<ListBackupSelectionsResponse> {
        private ListBackupSelectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupSelectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBackupSelectionsResponse> nextPage(ListBackupSelectionsResponse previousPage) {
            if (previousPage == null) {
                return ListBackupSelectionsPublisher.this.client.listBackupSelections(ListBackupSelectionsPublisher.this.firstRequest);
            }
            return ListBackupSelectionsPublisher.this.client.listBackupSelections((ListBackupSelectionsRequest)((Object)ListBackupSelectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

