/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse;
import software.amazon.awssdk.services.backup.model.RestoreJobsListMember;

public class ListRestoreJobsPublisher
implements SdkPublisher<ListRestoreJobsResponse> {
    private final BackupAsyncClient client;
    private final ListRestoreJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRestoreJobsPublisher(BackupAsyncClient client, ListRestoreJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRestoreJobsPublisher(BackupAsyncClient client, ListRestoreJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRestoreJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRestoreJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RestoreJobsListMember> restoreJobs() {
        Function<ListRestoreJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.restoreJobs() != null) {
                return response.restoreJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRestoreJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRestoreJobsResponseFetcher
    implements AsyncPageFetcher<ListRestoreJobsResponse> {
        private ListRestoreJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListRestoreJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRestoreJobsResponse> nextPage(ListRestoreJobsResponse previousPage) {
            if (previousPage == null) {
                return ListRestoreJobsPublisher.this.client.listRestoreJobs(ListRestoreJobsPublisher.this.firstRequest);
            }
            return ListRestoreJobsPublisher.this.client.listRestoreJobs((ListRestoreJobsRequest)((Object)ListRestoreJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

