/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.model.ListReportJobsRequest;
import software.amazon.awssdk.services.backup.model.ListReportJobsResponse;

public class ListReportJobsIterable
implements SdkIterable<ListReportJobsResponse> {
    private final BackupClient client;
    private final ListReportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReportJobsIterable(BackupClient client, ListReportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListReportJobsResponseFetcher();
    }

    public Iterator<ListReportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListReportJobsResponseFetcher
    implements SyncPageFetcher<ListReportJobsResponse> {
        private ListReportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListReportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReportJobsResponse nextPage(ListReportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListReportJobsIterable.this.client.listReportJobs(ListReportJobsIterable.this.firstRequest);
            }
            return ListReportJobsIterable.this.client.listReportJobs((ListReportJobsRequest)((Object)ListReportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

