/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.model.ListFrameworksRequest;
import software.amazon.awssdk.services.backup.model.ListFrameworksResponse;

public class ListFrameworksPublisher
implements SdkPublisher<ListFrameworksResponse> {
    private final BackupAsyncClient client;
    private final ListFrameworksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFrameworksPublisher(BackupAsyncClient client, ListFrameworksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFrameworksPublisher(BackupAsyncClient client, ListFrameworksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFrameworksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFrameworksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFrameworksResponseFetcher
    implements AsyncPageFetcher<ListFrameworksResponse> {
        private ListFrameworksResponseFetcher() {
        }

        public boolean hasNextPage(ListFrameworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFrameworksResponse> nextPage(ListFrameworksResponse previousPage) {
            if (previousPage == null) {
                return ListFrameworksPublisher.this.client.listFrameworks(ListFrameworksPublisher.this.firstRequest);
            }
            return ListFrameworksPublisher.this.client.listFrameworks((ListFrameworksRequest)((Object)ListFrameworksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

