/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse;

public class ListBackupPlanVersionsIterable
implements SdkIterable<ListBackupPlanVersionsResponse> {
    private final BackupClient client;
    private final ListBackupPlanVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBackupPlanVersionsIterable(BackupClient client, ListBackupPlanVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBackupPlanVersionsResponseFetcher();
    }

    public Iterator<ListBackupPlanVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBackupPlanVersionsResponseFetcher
    implements SyncPageFetcher<ListBackupPlanVersionsResponse> {
        private ListBackupPlanVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBackupPlanVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBackupPlanVersionsResponse nextPage(ListBackupPlanVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListBackupPlanVersionsIterable.this.client.listBackupPlanVersions(ListBackupPlanVersionsIterable.this.firstRequest);
            }
            return ListBackupPlanVersionsIterable.this.client.listBackupPlanVersions((ListBackupPlanVersionsRequest)((Object)ListBackupPlanVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

