/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.FrameworkControl;
import software.amazon.awssdk.services.backup.model.FrameworkControlsCopier;
import software.amazon.awssdk.services.backup.model._stringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFrameworkRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, CreateFrameworkRequest> {
    private static final SdkField<String> FRAMEWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkName").getter(CreateFrameworkRequest.getter(CreateFrameworkRequest::frameworkName)).setter(CreateFrameworkRequest.setter(Builder::frameworkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkName").build()}).build();
    private static final SdkField<String> FRAMEWORK_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkDescription").getter(CreateFrameworkRequest.getter(CreateFrameworkRequest::frameworkDescription)).setter(CreateFrameworkRequest.setter(Builder::frameworkDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkDescription").build()}).build();
    private static final SdkField<List<FrameworkControl>> FRAMEWORK_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FrameworkControls").getter(CreateFrameworkRequest.getter(CreateFrameworkRequest::frameworkControls)).setter(CreateFrameworkRequest.setter(Builder::frameworkControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FrameworkControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(CreateFrameworkRequest.getter(CreateFrameworkRequest::idempotencyToken)).setter(CreateFrameworkRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> FRAMEWORK_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("FrameworkTags").getter(CreateFrameworkRequest.getter(CreateFrameworkRequest::frameworkTags)).setter(CreateFrameworkRequest.setter(Builder::frameworkTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_NAME_FIELD, FRAMEWORK_DESCRIPTION_FIELD, FRAMEWORK_CONTROLS_FIELD, IDEMPOTENCY_TOKEN_FIELD, FRAMEWORK_TAGS_FIELD));
    private final String frameworkName;
    private final String frameworkDescription;
    private final List<FrameworkControl> frameworkControls;
    private final String idempotencyToken;
    private final Map<String, String> frameworkTags;

    private CreateFrameworkRequest(BuilderImpl builder) {
        super(builder);
        this.frameworkName = builder.frameworkName;
        this.frameworkDescription = builder.frameworkDescription;
        this.frameworkControls = builder.frameworkControls;
        this.idempotencyToken = builder.idempotencyToken;
        this.frameworkTags = builder.frameworkTags;
    }

    public final String frameworkName() {
        return this.frameworkName;
    }

    public final String frameworkDescription() {
        return this.frameworkDescription;
    }

    public final boolean hasFrameworkControls() {
        return this.frameworkControls != null && !(this.frameworkControls instanceof SdkAutoConstructList);
    }

    public final List<FrameworkControl> frameworkControls() {
        return this.frameworkControls;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    public final boolean hasFrameworkTags() {
        return this.frameworkTags != null && !(this.frameworkTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> frameworkTags() {
        return this.frameworkTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFrameworkControls() ? this.frameworkControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFrameworkTags() ? this.frameworkTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFrameworkRequest)) {
            return false;
        }
        CreateFrameworkRequest other = (CreateFrameworkRequest)((Object)obj);
        return Objects.equals(this.frameworkName(), other.frameworkName()) && Objects.equals(this.frameworkDescription(), other.frameworkDescription()) && this.hasFrameworkControls() == other.hasFrameworkControls() && Objects.equals(this.frameworkControls(), other.frameworkControls()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && this.hasFrameworkTags() == other.hasFrameworkTags() && Objects.equals(this.frameworkTags(), other.frameworkTags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFrameworkRequest").add("FrameworkName", (Object)this.frameworkName()).add("FrameworkDescription", (Object)this.frameworkDescription()).add("FrameworkControls", this.hasFrameworkControls() ? this.frameworkControls() : null).add("IdempotencyToken", (Object)this.idempotencyToken()).add("FrameworkTags", this.hasFrameworkTags() ? this.frameworkTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FrameworkName": {
                return Optional.ofNullable(clazz.cast(this.frameworkName()));
            }
            case "FrameworkDescription": {
                return Optional.ofNullable(clazz.cast(this.frameworkDescription()));
            }
            case "FrameworkControls": {
                return Optional.ofNullable(clazz.cast(this.frameworkControls()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "FrameworkTags": {
                return Optional.ofNullable(clazz.cast(this.frameworkTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFrameworkRequest, T> g) {
        return obj -> g.apply((CreateFrameworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String frameworkName;
        private String frameworkDescription;
        private List<FrameworkControl> frameworkControls = DefaultSdkAutoConstructList.getInstance();
        private String idempotencyToken;
        private Map<String, String> frameworkTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFrameworkRequest model) {
            super(model);
            this.frameworkName(model.frameworkName);
            this.frameworkDescription(model.frameworkDescription);
            this.frameworkControls(model.frameworkControls);
            this.idempotencyToken(model.idempotencyToken);
            this.frameworkTags(model.frameworkTags);
        }

        public final String getFrameworkName() {
            return this.frameworkName;
        }

        public final void setFrameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
        }

        @Override
        @Transient
        public final Builder frameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
            return this;
        }

        public final String getFrameworkDescription() {
            return this.frameworkDescription;
        }

        public final void setFrameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
        }

        @Override
        @Transient
        public final Builder frameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
            return this;
        }

        public final List<FrameworkControl.Builder> getFrameworkControls() {
            List<FrameworkControl.Builder> result = FrameworkControlsCopier.copyToBuilder(this.frameworkControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFrameworkControls(Collection<FrameworkControl.BuilderImpl> frameworkControls) {
            this.frameworkControls = FrameworkControlsCopier.copyFromBuilder(frameworkControls);
        }

        @Override
        @Transient
        public final Builder frameworkControls(Collection<FrameworkControl> frameworkControls) {
            this.frameworkControls = FrameworkControlsCopier.copy(frameworkControls);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder frameworkControls(FrameworkControl ... frameworkControls) {
            this.frameworkControls(Arrays.asList(frameworkControls));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder frameworkControls(Consumer<FrameworkControl.Builder> ... frameworkControls) {
            this.frameworkControls(Stream.of(frameworkControls).map(c -> (FrameworkControl)((FrameworkControl.Builder)FrameworkControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        @Transient
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final Map<String, String> getFrameworkTags() {
            if (this.frameworkTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.frameworkTags;
        }

        public final void setFrameworkTags(Map<String, String> frameworkTags) {
            this.frameworkTags = _stringMapCopier.copy(frameworkTags);
        }

        @Override
        @Transient
        public final Builder frameworkTags(Map<String, String> frameworkTags) {
            this.frameworkTags = _stringMapCopier.copy(frameworkTags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFrameworkRequest build() {
            return new CreateFrameworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFrameworkRequest> {
        public Builder frameworkName(String var1);

        public Builder frameworkDescription(String var1);

        public Builder frameworkControls(Collection<FrameworkControl> var1);

        public Builder frameworkControls(FrameworkControl ... var1);

        public Builder frameworkControls(Consumer<FrameworkControl.Builder> ... var1);

        public Builder idempotencyToken(String var1);

        public Builder frameworkTags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

