/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupJobState;
import software.amazon.awssdk.services.backup.model.BackupOptionsCopier;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.RecoveryPointCreator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBackupJobResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, DescribeBackupJobResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::accountId)).setter(DescribeBackupJobResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> BACKUP_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupJobId").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::backupJobId)).setter(DescribeBackupJobResponse.setter(Builder::backupJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupJobId").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::backupVaultName)).setter(DescribeBackupJobResponse.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultArn").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::backupVaultArn)).setter(DescribeBackupJobResponse.setter(Builder::backupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()}).build();
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::recoveryPointArn)).setter(DescribeBackupJobResponse.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::resourceArn)).setter(DescribeBackupJobResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::creationDate)).setter(DescribeBackupJobResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionDate").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::completionDate)).setter(DescribeBackupJobResponse.setter(Builder::completionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::stateAsString)).setter(DescribeBackupJobResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::statusMessage)).setter(DescribeBackupJobResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> PERCENT_DONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PercentDone").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::percentDone)).setter(DescribeBackupJobResponse.setter(Builder::percentDone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentDone").build()}).build();
    private static final SdkField<Long> BACKUP_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BackupSizeInBytes").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::backupSizeInBytes)).setter(DescribeBackupJobResponse.setter(Builder::backupSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeInBytes").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::iamRoleArn)).setter(DescribeBackupJobResponse.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<RecoveryPointCreator> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::createdBy)).setter(DescribeBackupJobResponse.setter(Builder::createdBy)).constructor(RecoveryPointCreator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::resourceType)).setter(DescribeBackupJobResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Long> BYTES_TRANSFERRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BytesTransferred").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::bytesTransferred)).setter(DescribeBackupJobResponse.setter(Builder::bytesTransferred)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesTransferred").build()}).build();
    private static final SdkField<Instant> EXPECTED_COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpectedCompletionDate").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::expectedCompletionDate)).setter(DescribeBackupJobResponse.setter(Builder::expectedCompletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedCompletionDate").build()}).build();
    private static final SdkField<Instant> START_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartBy").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::startBy)).setter(DescribeBackupJobResponse.setter(Builder::startBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartBy").build()}).build();
    private static final SdkField<Map<String, String>> BACKUP_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("BackupOptions").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::backupOptions)).setter(DescribeBackupJobResponse.setter(Builder::backupOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> BACKUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupType").getter(DescribeBackupJobResponse.getter(DescribeBackupJobResponse::backupType)).setter(DescribeBackupJobResponse.setter(Builder::backupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BACKUP_JOB_ID_FIELD, BACKUP_VAULT_NAME_FIELD, BACKUP_VAULT_ARN_FIELD, RECOVERY_POINT_ARN_FIELD, RESOURCE_ARN_FIELD, CREATION_DATE_FIELD, COMPLETION_DATE_FIELD, STATE_FIELD, STATUS_MESSAGE_FIELD, PERCENT_DONE_FIELD, BACKUP_SIZE_IN_BYTES_FIELD, IAM_ROLE_ARN_FIELD, CREATED_BY_FIELD, RESOURCE_TYPE_FIELD, BYTES_TRANSFERRED_FIELD, EXPECTED_COMPLETION_DATE_FIELD, START_BY_FIELD, BACKUP_OPTIONS_FIELD, BACKUP_TYPE_FIELD));
    private final String accountId;
    private final String backupJobId;
    private final String backupVaultName;
    private final String backupVaultArn;
    private final String recoveryPointArn;
    private final String resourceArn;
    private final Instant creationDate;
    private final Instant completionDate;
    private final String state;
    private final String statusMessage;
    private final String percentDone;
    private final Long backupSizeInBytes;
    private final String iamRoleArn;
    private final RecoveryPointCreator createdBy;
    private final String resourceType;
    private final Long bytesTransferred;
    private final Instant expectedCompletionDate;
    private final Instant startBy;
    private final Map<String, String> backupOptions;
    private final String backupType;

    private DescribeBackupJobResponse(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.backupJobId = builder.backupJobId;
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultArn = builder.backupVaultArn;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.resourceArn = builder.resourceArn;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.percentDone = builder.percentDone;
        this.backupSizeInBytes = builder.backupSizeInBytes;
        this.iamRoleArn = builder.iamRoleArn;
        this.createdBy = builder.createdBy;
        this.resourceType = builder.resourceType;
        this.bytesTransferred = builder.bytesTransferred;
        this.expectedCompletionDate = builder.expectedCompletionDate;
        this.startBy = builder.startBy;
        this.backupOptions = builder.backupOptions;
        this.backupType = builder.backupType;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String backupJobId() {
        return this.backupJobId;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final String backupVaultArn() {
        return this.backupVaultArn;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant completionDate() {
        return this.completionDate;
    }

    public final BackupJobState state() {
        return BackupJobState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String percentDone() {
        return this.percentDone;
    }

    public final Long backupSizeInBytes() {
        return this.backupSizeInBytes;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final RecoveryPointCreator createdBy() {
        return this.createdBy;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Long bytesTransferred() {
        return this.bytesTransferred;
    }

    public final Instant expectedCompletionDate() {
        return this.expectedCompletionDate;
    }

    public final Instant startBy() {
        return this.startBy;
    }

    public final boolean hasBackupOptions() {
        return this.backupOptions != null && !(this.backupOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> backupOptions() {
        return this.backupOptions;
    }

    public final String backupType() {
        return this.backupType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentDone());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesTransferred());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedCompletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.startBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackupOptions() ? this.backupOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.backupType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBackupJobResponse)) {
            return false;
        }
        DescribeBackupJobResponse other = (DescribeBackupJobResponse)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.backupJobId(), other.backupJobId()) && Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.backupVaultArn(), other.backupVaultArn()) && Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.completionDate(), other.completionDate()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.percentDone(), other.percentDone()) && Objects.equals(this.backupSizeInBytes(), other.backupSizeInBytes()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.bytesTransferred(), other.bytesTransferred()) && Objects.equals(this.expectedCompletionDate(), other.expectedCompletionDate()) && Objects.equals(this.startBy(), other.startBy()) && this.hasBackupOptions() == other.hasBackupOptions() && Objects.equals(this.backupOptions(), other.backupOptions()) && Objects.equals(this.backupType(), other.backupType());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBackupJobResponse").add("AccountId", (Object)this.accountId()).add("BackupJobId", (Object)this.backupJobId()).add("BackupVaultName", (Object)this.backupVaultName()).add("BackupVaultArn", (Object)this.backupVaultArn()).add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("ResourceArn", (Object)this.resourceArn()).add("CreationDate", (Object)this.creationDate()).add("CompletionDate", (Object)this.completionDate()).add("State", (Object)this.stateAsString()).add("StatusMessage", (Object)this.statusMessage()).add("PercentDone", (Object)this.percentDone()).add("BackupSizeInBytes", (Object)this.backupSizeInBytes()).add("IamRoleArn", (Object)this.iamRoleArn()).add("CreatedBy", (Object)this.createdBy()).add("ResourceType", (Object)this.resourceType()).add("BytesTransferred", (Object)this.bytesTransferred()).add("ExpectedCompletionDate", (Object)this.expectedCompletionDate()).add("StartBy", (Object)this.startBy()).add("BackupOptions", this.hasBackupOptions() ? this.backupOptions() : null).add("BackupType", (Object)this.backupType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "BackupJobId": {
                return Optional.ofNullable(clazz.cast(this.backupJobId()));
            }
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "BackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.backupVaultArn()));
            }
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CompletionDate": {
                return Optional.ofNullable(clazz.cast(this.completionDate()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "PercentDone": {
                return Optional.ofNullable(clazz.cast(this.percentDone()));
            }
            case "BackupSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.backupSizeInBytes()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "BytesTransferred": {
                return Optional.ofNullable(clazz.cast(this.bytesTransferred()));
            }
            case "ExpectedCompletionDate": {
                return Optional.ofNullable(clazz.cast(this.expectedCompletionDate()));
            }
            case "StartBy": {
                return Optional.ofNullable(clazz.cast(this.startBy()));
            }
            case "BackupOptions": {
                return Optional.ofNullable(clazz.cast(this.backupOptions()));
            }
            case "BackupType": {
                return Optional.ofNullable(clazz.cast(this.backupType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBackupJobResponse, T> g) {
        return obj -> g.apply((DescribeBackupJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String accountId;
        private String backupJobId;
        private String backupVaultName;
        private String backupVaultArn;
        private String recoveryPointArn;
        private String resourceArn;
        private Instant creationDate;
        private Instant completionDate;
        private String state;
        private String statusMessage;
        private String percentDone;
        private Long backupSizeInBytes;
        private String iamRoleArn;
        private RecoveryPointCreator createdBy;
        private String resourceType;
        private Long bytesTransferred;
        private Instant expectedCompletionDate;
        private Instant startBy;
        private Map<String, String> backupOptions = DefaultSdkAutoConstructMap.getInstance();
        private String backupType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBackupJobResponse model) {
            super(model);
            this.accountId(model.accountId);
            this.backupJobId(model.backupJobId);
            this.backupVaultName(model.backupVaultName);
            this.backupVaultArn(model.backupVaultArn);
            this.recoveryPointArn(model.recoveryPointArn);
            this.resourceArn(model.resourceArn);
            this.creationDate(model.creationDate);
            this.completionDate(model.completionDate);
            this.state(model.state);
            this.statusMessage(model.statusMessage);
            this.percentDone(model.percentDone);
            this.backupSizeInBytes(model.backupSizeInBytes);
            this.iamRoleArn(model.iamRoleArn);
            this.createdBy(model.createdBy);
            this.resourceType(model.resourceType);
            this.bytesTransferred(model.bytesTransferred);
            this.expectedCompletionDate(model.expectedCompletionDate);
            this.startBy(model.startBy);
            this.backupOptions(model.backupOptions);
            this.backupType(model.backupType);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBackupJobId() {
            return this.backupJobId;
        }

        public final void setBackupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
        }

        @Override
        @Transient
        public final Builder backupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
            return this;
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        @Transient
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        @Transient
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        @Transient
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getCompletionDate() {
            return this.completionDate;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        @Override
        @Transient
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(BackupJobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getPercentDone() {
            return this.percentDone;
        }

        public final void setPercentDone(String percentDone) {
            this.percentDone = percentDone;
        }

        @Override
        @Transient
        public final Builder percentDone(String percentDone) {
            this.percentDone = percentDone;
            return this;
        }

        public final Long getBackupSizeInBytes() {
            return this.backupSizeInBytes;
        }

        public final void setBackupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
        }

        @Override
        @Transient
        public final Builder backupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        @Transient
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final RecoveryPointCreator.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(RecoveryPointCreator.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        @Transient
        public final Builder createdBy(RecoveryPointCreator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Long getBytesTransferred() {
            return this.bytesTransferred;
        }

        public final void setBytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
        }

        @Override
        @Transient
        public final Builder bytesTransferred(Long bytesTransferred) {
            this.bytesTransferred = bytesTransferred;
            return this;
        }

        public final Instant getExpectedCompletionDate() {
            return this.expectedCompletionDate;
        }

        public final void setExpectedCompletionDate(Instant expectedCompletionDate) {
            this.expectedCompletionDate = expectedCompletionDate;
        }

        @Override
        @Transient
        public final Builder expectedCompletionDate(Instant expectedCompletionDate) {
            this.expectedCompletionDate = expectedCompletionDate;
            return this;
        }

        public final Instant getStartBy() {
            return this.startBy;
        }

        public final void setStartBy(Instant startBy) {
            this.startBy = startBy;
        }

        @Override
        @Transient
        public final Builder startBy(Instant startBy) {
            this.startBy = startBy;
            return this;
        }

        public final Map<String, String> getBackupOptions() {
            if (this.backupOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.backupOptions;
        }

        public final void setBackupOptions(Map<String, String> backupOptions) {
            this.backupOptions = BackupOptionsCopier.copy(backupOptions);
        }

        @Override
        @Transient
        public final Builder backupOptions(Map<String, String> backupOptions) {
            this.backupOptions = BackupOptionsCopier.copy(backupOptions);
            return this;
        }

        public final String getBackupType() {
            return this.backupType;
        }

        public final void setBackupType(String backupType) {
            this.backupType = backupType;
        }

        @Override
        @Transient
        public final Builder backupType(String backupType) {
            this.backupType = backupType;
            return this;
        }

        @Override
        public DescribeBackupJobResponse build() {
            return new DescribeBackupJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBackupJobResponse> {
        public Builder accountId(String var1);

        public Builder backupJobId(String var1);

        public Builder backupVaultName(String var1);

        public Builder backupVaultArn(String var1);

        public Builder recoveryPointArn(String var1);

        public Builder resourceArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder completionDate(Instant var1);

        public Builder state(String var1);

        public Builder state(BackupJobState var1);

        public Builder statusMessage(String var1);

        public Builder percentDone(String var1);

        public Builder backupSizeInBytes(Long var1);

        public Builder iamRoleArn(String var1);

        public Builder createdBy(RecoveryPointCreator var1);

        default public Builder createdBy(Consumer<RecoveryPointCreator.Builder> createdBy) {
            return this.createdBy((RecoveryPointCreator)((RecoveryPointCreator.Builder)RecoveryPointCreator.builder().applyMutation(createdBy)).build());
        }

        public Builder resourceType(String var1);

        public Builder bytesTransferred(Long var1);

        public Builder expectedCompletionDate(Instant var1);

        public Builder startBy(Instant var1);

        public Builder backupOptions(Map<String, String> var1);

        public Builder backupType(String var1);
    }
}

