/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.AdvancedBackupSetting;
import software.amazon.awssdk.services.backup.model.AdvancedBackupSettingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupPlansListMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackupPlansListMember> {
    private static final SdkField<String> BACKUP_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanArn").getter(BackupPlansListMember.getter(BackupPlansListMember::backupPlanArn)).setter(BackupPlansListMember.setter(Builder::backupPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanArn").build()}).build();
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanId").getter(BackupPlansListMember.getter(BackupPlansListMember::backupPlanId)).setter(BackupPlansListMember.setter(Builder::backupPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(BackupPlansListMember.getter(BackupPlansListMember::creationDate)).setter(BackupPlansListMember.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> DELETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletionDate").getter(BackupPlansListMember.getter(BackupPlansListMember::deletionDate)).setter(BackupPlansListMember.setter(Builder::deletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionDate").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(BackupPlansListMember.getter(BackupPlansListMember::versionId)).setter(BackupPlansListMember.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final SdkField<String> BACKUP_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanName").getter(BackupPlansListMember.getter(BackupPlansListMember::backupPlanName)).setter(BackupPlansListMember.setter(Builder::backupPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanName").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(BackupPlansListMember.getter(BackupPlansListMember::creatorRequestId)).setter(BackupPlansListMember.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<Instant> LAST_EXECUTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastExecutionDate").getter(BackupPlansListMember.getter(BackupPlansListMember::lastExecutionDate)).setter(BackupPlansListMember.setter(Builder::lastExecutionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionDate").build()}).build();
    private static final SdkField<List<AdvancedBackupSetting>> ADVANCED_BACKUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdvancedBackupSettings").getter(BackupPlansListMember.getter(BackupPlansListMember::advancedBackupSettings)).setter(BackupPlansListMember.setter(Builder::advancedBackupSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedBackupSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdvancedBackupSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_ARN_FIELD, BACKUP_PLAN_ID_FIELD, CREATION_DATE_FIELD, DELETION_DATE_FIELD, VERSION_ID_FIELD, BACKUP_PLAN_NAME_FIELD, CREATOR_REQUEST_ID_FIELD, LAST_EXECUTION_DATE_FIELD, ADVANCED_BACKUP_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String backupPlanArn;
    private final String backupPlanId;
    private final Instant creationDate;
    private final Instant deletionDate;
    private final String versionId;
    private final String backupPlanName;
    private final String creatorRequestId;
    private final Instant lastExecutionDate;
    private final List<AdvancedBackupSetting> advancedBackupSettings;

    private BackupPlansListMember(BuilderImpl builder) {
        this.backupPlanArn = builder.backupPlanArn;
        this.backupPlanId = builder.backupPlanId;
        this.creationDate = builder.creationDate;
        this.deletionDate = builder.deletionDate;
        this.versionId = builder.versionId;
        this.backupPlanName = builder.backupPlanName;
        this.creatorRequestId = builder.creatorRequestId;
        this.lastExecutionDate = builder.lastExecutionDate;
        this.advancedBackupSettings = builder.advancedBackupSettings;
    }

    public final String backupPlanArn() {
        return this.backupPlanArn;
    }

    public final String backupPlanId() {
        return this.backupPlanId;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant deletionDate() {
        return this.deletionDate;
    }

    public final String versionId() {
        return this.versionId;
    }

    public final String backupPlanName() {
        return this.backupPlanName;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final Instant lastExecutionDate() {
        return this.lastExecutionDate;
    }

    public final boolean hasAdvancedBackupSettings() {
        return this.advancedBackupSettings != null && !(this.advancedBackupSettings instanceof SdkAutoConstructList);
    }

    public final List<AdvancedBackupSetting> advancedBackupSettings() {
        return this.advancedBackupSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedBackupSettings() ? this.advancedBackupSettings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupPlansListMember)) {
            return false;
        }
        BackupPlansListMember other = (BackupPlansListMember)obj;
        return Objects.equals(this.backupPlanArn(), other.backupPlanArn()) && Objects.equals(this.backupPlanId(), other.backupPlanId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.deletionDate(), other.deletionDate()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.backupPlanName(), other.backupPlanName()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.lastExecutionDate(), other.lastExecutionDate()) && this.hasAdvancedBackupSettings() == other.hasAdvancedBackupSettings() && Objects.equals(this.advancedBackupSettings(), other.advancedBackupSettings());
    }

    public final String toString() {
        return ToString.builder((String)"BackupPlansListMember").add("BackupPlanArn", (Object)this.backupPlanArn()).add("BackupPlanId", (Object)this.backupPlanId()).add("CreationDate", (Object)this.creationDate()).add("DeletionDate", (Object)this.deletionDate()).add("VersionId", (Object)this.versionId()).add("BackupPlanName", (Object)this.backupPlanName()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("LastExecutionDate", (Object)this.lastExecutionDate()).add("AdvancedBackupSettings", this.hasAdvancedBackupSettings() ? this.advancedBackupSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupPlanArn": {
                return Optional.ofNullable(clazz.cast(this.backupPlanArn()));
            }
            case "BackupPlanId": {
                return Optional.ofNullable(clazz.cast(this.backupPlanId()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "DeletionDate": {
                return Optional.ofNullable(clazz.cast(this.deletionDate()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "BackupPlanName": {
                return Optional.ofNullable(clazz.cast(this.backupPlanName()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "LastExecutionDate": {
                return Optional.ofNullable(clazz.cast(this.lastExecutionDate()));
            }
            case "AdvancedBackupSettings": {
                return Optional.ofNullable(clazz.cast(this.advancedBackupSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupPlansListMember, T> g) {
        return obj -> g.apply((BackupPlansListMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupPlanArn;
        private String backupPlanId;
        private Instant creationDate;
        private Instant deletionDate;
        private String versionId;
        private String backupPlanName;
        private String creatorRequestId;
        private Instant lastExecutionDate;
        private List<AdvancedBackupSetting> advancedBackupSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BackupPlansListMember model) {
            this.backupPlanArn(model.backupPlanArn);
            this.backupPlanId(model.backupPlanId);
            this.creationDate(model.creationDate);
            this.deletionDate(model.deletionDate);
            this.versionId(model.versionId);
            this.backupPlanName(model.backupPlanName);
            this.creatorRequestId(model.creatorRequestId);
            this.lastExecutionDate(model.lastExecutionDate);
            this.advancedBackupSettings(model.advancedBackupSettings);
        }

        public final String getBackupPlanArn() {
            return this.backupPlanArn;
        }

        @Override
        public final Builder backupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
            return this;
        }

        public final void setBackupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
        }

        public final String getBackupPlanId() {
            return this.backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getDeletionDate() {
            return this.deletionDate;
        }

        @Override
        public final Builder deletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        public final void setDeletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getBackupPlanName() {
            return this.backupPlanName;
        }

        @Override
        public final Builder backupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
            return this;
        }

        public final void setBackupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final Instant getLastExecutionDate() {
            return this.lastExecutionDate;
        }

        @Override
        public final Builder lastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
            return this;
        }

        public final void setLastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
        }

        public final Collection<AdvancedBackupSetting.Builder> getAdvancedBackupSettings() {
            if (this.advancedBackupSettings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.advancedBackupSettings != null ? (Collection)this.advancedBackupSettings.stream().map(AdvancedBackupSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder advancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copy(advancedBackupSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(AdvancedBackupSetting ... advancedBackupSettings) {
            this.advancedBackupSettings(Arrays.asList(advancedBackupSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder> ... advancedBackupSettings) {
            this.advancedBackupSettings(Stream.of(advancedBackupSettings).map(c -> (AdvancedBackupSetting)((AdvancedBackupSetting.Builder)AdvancedBackupSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdvancedBackupSettings(Collection<AdvancedBackupSetting.BuilderImpl> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copyFromBuilder(advancedBackupSettings);
        }

        public BackupPlansListMember build() {
            return new BackupPlansListMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackupPlansListMember> {
        public Builder backupPlanArn(String var1);

        public Builder backupPlanId(String var1);

        public Builder creationDate(Instant var1);

        public Builder deletionDate(Instant var1);

        public Builder versionId(String var1);

        public Builder backupPlanName(String var1);

        public Builder creatorRequestId(String var1);

        public Builder lastExecutionDate(Instant var1);

        public Builder advancedBackupSettings(Collection<AdvancedBackupSetting> var1);

        public Builder advancedBackupSettings(AdvancedBackupSetting ... var1);

        public Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder> ... var1);
    }
}

