/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse;

public class ListRestoreJobsIterable
implements SdkIterable<ListRestoreJobsResponse> {
    private final BackupClient client;
    private final ListRestoreJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRestoreJobsIterable(BackupClient client, ListRestoreJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRestoreJobsResponseFetcher();
    }

    public Iterator<ListRestoreJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRestoreJobsResponseFetcher
    implements SyncPageFetcher<ListRestoreJobsResponse> {
        private ListRestoreJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListRestoreJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRestoreJobsResponse nextPage(ListRestoreJobsResponse previousPage) {
            if (previousPage == null) {
                return ListRestoreJobsIterable.this.client.listRestoreJobs(ListRestoreJobsIterable.this.firstRequest);
            }
            return ListRestoreJobsIterable.this.client.listRestoreJobs((ListRestoreJobsRequest)((Object)ListRestoreJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

