/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBackupVaultResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, CreateBackupVaultResponse> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(CreateBackupVaultResponse.getter(CreateBackupVaultResponse::backupVaultName)).setter(CreateBackupVaultResponse.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultArn").getter(CreateBackupVaultResponse.getter(CreateBackupVaultResponse::backupVaultArn)).setter(CreateBackupVaultResponse.setter(Builder::backupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(CreateBackupVaultResponse.getter(CreateBackupVaultResponse::creationDate)).setter(CreateBackupVaultResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD, BACKUP_VAULT_ARN_FIELD, CREATION_DATE_FIELD));
    private final String backupVaultName;
    private final String backupVaultArn;
    private final Instant creationDate;

    private CreateBackupVaultResponse(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultArn = builder.backupVaultArn;
        this.creationDate = builder.creationDate;
    }

    public String backupVaultName() {
        return this.backupVaultName;
    }

    public String backupVaultArn() {
        return this.backupVaultArn;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackupVaultResponse)) {
            return false;
        }
        CreateBackupVaultResponse other = (CreateBackupVaultResponse)((Object)obj);
        return Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.backupVaultArn(), other.backupVaultArn()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"CreateBackupVaultResponse").add("BackupVaultName", (Object)this.backupVaultName()).add("BackupVaultArn", (Object)this.backupVaultArn()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "BackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.backupVaultArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackupVaultResponse, T> g) {
        return obj -> g.apply((CreateBackupVaultResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String backupVaultName;
        private String backupVaultArn;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackupVaultResponse model) {
            super(model);
            this.backupVaultName(model.backupVaultName);
            this.backupVaultArn(model.backupVaultArn);
            this.creationDate(model.creationDate);
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        public final String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public CreateBackupVaultResponse build() {
            return new CreateBackupVaultResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBackupVaultResponse> {
        public Builder backupVaultName(String var1);

        public Builder backupVaultArn(String var1);

        public Builder creationDate(Instant var1);
    }
}

