/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.RecoveryPointByBackupVault;
import software.amazon.awssdk.services.backup.model.RecoveryPointByBackupVaultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecoveryPointsByBackupVaultResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListRecoveryPointsByBackupVaultResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRecoveryPointsByBackupVaultResponse.getter(ListRecoveryPointsByBackupVaultResponse::nextToken)).setter(ListRecoveryPointsByBackupVaultResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RecoveryPointByBackupVault>> RECOVERY_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecoveryPoints").getter(ListRecoveryPointsByBackupVaultResponse.getter(ListRecoveryPointsByBackupVaultResponse::recoveryPoints)).setter(ListRecoveryPointsByBackupVaultResponse.setter(Builder::recoveryPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecoveryPointByBackupVault::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RECOVERY_POINTS_FIELD));
    private final String nextToken;
    private final List<RecoveryPointByBackupVault> recoveryPoints;

    private ListRecoveryPointsByBackupVaultResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.recoveryPoints = builder.recoveryPoints;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasRecoveryPoints() {
        return this.recoveryPoints != null && !(this.recoveryPoints instanceof SdkAutoConstructList);
    }

    public List<RecoveryPointByBackupVault> recoveryPoints() {
        return this.recoveryPoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecoveryPoints() ? this.recoveryPoints() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecoveryPointsByBackupVaultResponse)) {
            return false;
        }
        ListRecoveryPointsByBackupVaultResponse other = (ListRecoveryPointsByBackupVaultResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRecoveryPoints() == other.hasRecoveryPoints() && Objects.equals(this.recoveryPoints(), other.recoveryPoints());
    }

    public String toString() {
        return ToString.builder((String)"ListRecoveryPointsByBackupVaultResponse").add("NextToken", (Object)this.nextToken()).add("RecoveryPoints", this.hasRecoveryPoints() ? this.recoveryPoints() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RecoveryPoints": {
                return Optional.ofNullable(clazz.cast(this.recoveryPoints()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecoveryPointsByBackupVaultResponse, T> g) {
        return obj -> g.apply((ListRecoveryPointsByBackupVaultResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RecoveryPointByBackupVault> recoveryPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecoveryPointsByBackupVaultResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.recoveryPoints(model.recoveryPoints);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<RecoveryPointByBackupVault.Builder> getRecoveryPoints() {
            if (this.recoveryPoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recoveryPoints != null ? (Collection)this.recoveryPoints.stream().map(RecoveryPointByBackupVault::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recoveryPoints(Collection<RecoveryPointByBackupVault> recoveryPoints) {
            this.recoveryPoints = RecoveryPointByBackupVaultListCopier.copy(recoveryPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryPoints(RecoveryPointByBackupVault ... recoveryPoints) {
            this.recoveryPoints(Arrays.asList(recoveryPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryPoints(Consumer<RecoveryPointByBackupVault.Builder> ... recoveryPoints) {
            this.recoveryPoints(Stream.of(recoveryPoints).map(c -> (RecoveryPointByBackupVault)((RecoveryPointByBackupVault.Builder)RecoveryPointByBackupVault.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecoveryPoints(Collection<RecoveryPointByBackupVault.BuilderImpl> recoveryPoints) {
            this.recoveryPoints = RecoveryPointByBackupVaultListCopier.copyFromBuilder(recoveryPoints);
        }

        @Override
        public ListRecoveryPointsByBackupVaultResponse build() {
            return new ListRecoveryPointsByBackupVaultResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecoveryPointsByBackupVaultResponse> {
        public Builder nextToken(String var1);

        public Builder recoveryPoints(Collection<RecoveryPointByBackupVault> var1);

        public Builder recoveryPoints(RecoveryPointByBackupVault ... var1);

        public Builder recoveryPoints(Consumer<RecoveryPointByBackupVault.Builder> ... var1);
    }
}

