/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.AdvancedBackupSetting;
import software.amazon.awssdk.services.backup.model.AdvancedBackupSettingsCopier;
import software.amazon.awssdk.services.backup.model.BackupRuleInput;
import software.amazon.awssdk.services.backup.model.BackupRulesInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupPlanInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackupPlanInput> {
    private static final SdkField<String> BACKUP_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanName").getter(BackupPlanInput.getter(BackupPlanInput::backupPlanName)).setter(BackupPlanInput.setter(Builder::backupPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanName").build()}).build();
    private static final SdkField<List<BackupRuleInput>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(BackupPlanInput.getter(BackupPlanInput::rules)).setter(BackupPlanInput.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackupRuleInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AdvancedBackupSetting>> ADVANCED_BACKUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdvancedBackupSettings").getter(BackupPlanInput.getter(BackupPlanInput::advancedBackupSettings)).setter(BackupPlanInput.setter(Builder::advancedBackupSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedBackupSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdvancedBackupSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_NAME_FIELD, RULES_FIELD, ADVANCED_BACKUP_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String backupPlanName;
    private final List<BackupRuleInput> rules;
    private final List<AdvancedBackupSetting> advancedBackupSettings;

    private BackupPlanInput(BuilderImpl builder) {
        this.backupPlanName = builder.backupPlanName;
        this.rules = builder.rules;
        this.advancedBackupSettings = builder.advancedBackupSettings;
    }

    public String backupPlanName() {
        return this.backupPlanName;
    }

    public boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public List<BackupRuleInput> rules() {
        return this.rules;
    }

    public boolean hasAdvancedBackupSettings() {
        return this.advancedBackupSettings != null && !(this.advancedBackupSettings instanceof SdkAutoConstructList);
    }

    public List<AdvancedBackupSetting> advancedBackupSettings() {
        return this.advancedBackupSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedBackupSettings() ? this.advancedBackupSettings() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupPlanInput)) {
            return false;
        }
        BackupPlanInput other = (BackupPlanInput)obj;
        return Objects.equals(this.backupPlanName(), other.backupPlanName()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && this.hasAdvancedBackupSettings() == other.hasAdvancedBackupSettings() && Objects.equals(this.advancedBackupSettings(), other.advancedBackupSettings());
    }

    public String toString() {
        return ToString.builder((String)"BackupPlanInput").add("BackupPlanName", (Object)this.backupPlanName()).add("Rules", this.hasRules() ? this.rules() : null).add("AdvancedBackupSettings", this.hasAdvancedBackupSettings() ? this.advancedBackupSettings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupPlanName": {
                return Optional.ofNullable(clazz.cast(this.backupPlanName()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "AdvancedBackupSettings": {
                return Optional.ofNullable(clazz.cast(this.advancedBackupSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupPlanInput, T> g) {
        return obj -> g.apply((BackupPlanInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupPlanName;
        private List<BackupRuleInput> rules = DefaultSdkAutoConstructList.getInstance();
        private List<AdvancedBackupSetting> advancedBackupSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BackupPlanInput model) {
            this.backupPlanName(model.backupPlanName);
            this.rules(model.rules);
            this.advancedBackupSettings(model.advancedBackupSettings);
        }

        public final String getBackupPlanName() {
            return this.backupPlanName;
        }

        @Override
        public final Builder backupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
            return this;
        }

        public final void setBackupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
        }

        public final Collection<BackupRuleInput.Builder> getRules() {
            if (this.rules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rules != null ? (Collection)this.rules.stream().map(BackupRuleInput::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<BackupRuleInput> rules) {
            this.rules = BackupRulesInputCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(BackupRuleInput ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<BackupRuleInput.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (BackupRuleInput)((BackupRuleInput.Builder)BackupRuleInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<BackupRuleInput.BuilderImpl> rules) {
            this.rules = BackupRulesInputCopier.copyFromBuilder(rules);
        }

        public final Collection<AdvancedBackupSetting.Builder> getAdvancedBackupSettings() {
            if (this.advancedBackupSettings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.advancedBackupSettings != null ? (Collection)this.advancedBackupSettings.stream().map(AdvancedBackupSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder advancedBackupSettings(Collection<AdvancedBackupSetting> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copy(advancedBackupSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(AdvancedBackupSetting ... advancedBackupSettings) {
            this.advancedBackupSettings(Arrays.asList(advancedBackupSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder> ... advancedBackupSettings) {
            this.advancedBackupSettings(Stream.of(advancedBackupSettings).map(c -> (AdvancedBackupSetting)((AdvancedBackupSetting.Builder)AdvancedBackupSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdvancedBackupSettings(Collection<AdvancedBackupSetting.BuilderImpl> advancedBackupSettings) {
            this.advancedBackupSettings = AdvancedBackupSettingsCopier.copyFromBuilder(advancedBackupSettings);
        }

        public BackupPlanInput build() {
            return new BackupPlanInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackupPlanInput> {
        public Builder backupPlanName(String var1);

        public Builder rules(Collection<BackupRuleInput> var1);

        public Builder rules(BackupRuleInput ... var1);

        public Builder rules(Consumer<BackupRuleInput.Builder> ... var1);

        public Builder advancedBackupSettings(Collection<AdvancedBackupSetting> var1);

        public Builder advancedBackupSettings(AdvancedBackupSetting ... var1);

        public Builder advancedBackupSettings(Consumer<AdvancedBackupSetting.Builder> ... var1);
    }
}

