/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBackupVaultResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, DescribeBackupVaultResponse> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBackupVaultResponse.getter(DescribeBackupVaultResponse::backupVaultName)).setter(DescribeBackupVaultResponse.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBackupVaultResponse.getter(DescribeBackupVaultResponse::backupVaultArn)).setter(DescribeBackupVaultResponse.setter(Builder::backupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBackupVaultResponse.getter(DescribeBackupVaultResponse::encryptionKeyArn)).setter(DescribeBackupVaultResponse.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeBackupVaultResponse.getter(DescribeBackupVaultResponse::creationDate)).setter(DescribeBackupVaultResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeBackupVaultResponse.getter(DescribeBackupVaultResponse::creatorRequestId)).setter(DescribeBackupVaultResponse.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<Long> NUMBER_OF_RECOVERY_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DescribeBackupVaultResponse.getter(DescribeBackupVaultResponse::numberOfRecoveryPoints)).setter(DescribeBackupVaultResponse.setter(Builder::numberOfRecoveryPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfRecoveryPoints").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD, BACKUP_VAULT_ARN_FIELD, ENCRYPTION_KEY_ARN_FIELD, CREATION_DATE_FIELD, CREATOR_REQUEST_ID_FIELD, NUMBER_OF_RECOVERY_POINTS_FIELD));
    private final String backupVaultName;
    private final String backupVaultArn;
    private final String encryptionKeyArn;
    private final Instant creationDate;
    private final String creatorRequestId;
    private final Long numberOfRecoveryPoints;

    private DescribeBackupVaultResponse(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultArn = builder.backupVaultArn;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.creationDate = builder.creationDate;
        this.creatorRequestId = builder.creatorRequestId;
        this.numberOfRecoveryPoints = builder.numberOfRecoveryPoints;
    }

    public String backupVaultName() {
        return this.backupVaultName;
    }

    public String backupVaultArn() {
        return this.backupVaultArn;
    }

    public String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public String creatorRequestId() {
        return this.creatorRequestId;
    }

    public Long numberOfRecoveryPoints() {
        return this.numberOfRecoveryPoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRecoveryPoints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBackupVaultResponse)) {
            return false;
        }
        DescribeBackupVaultResponse other = (DescribeBackupVaultResponse)((Object)obj);
        return Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.backupVaultArn(), other.backupVaultArn()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.numberOfRecoveryPoints(), other.numberOfRecoveryPoints());
    }

    public String toString() {
        return ToString.builder((String)"DescribeBackupVaultResponse").add("BackupVaultName", (Object)this.backupVaultName()).add("BackupVaultArn", (Object)this.backupVaultArn()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("CreationDate", (Object)this.creationDate()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("NumberOfRecoveryPoints", (Object)this.numberOfRecoveryPoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "BackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.backupVaultArn()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "NumberOfRecoveryPoints": {
                return Optional.ofNullable(clazz.cast(this.numberOfRecoveryPoints()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBackupVaultResponse, T> g) {
        return obj -> g.apply((DescribeBackupVaultResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String backupVaultName;
        private String backupVaultArn;
        private String encryptionKeyArn;
        private Instant creationDate;
        private String creatorRequestId;
        private Long numberOfRecoveryPoints;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBackupVaultResponse model) {
            super(model);
            this.backupVaultName(model.backupVaultName);
            this.backupVaultArn(model.backupVaultArn);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.creationDate(model.creationDate);
            this.creatorRequestId(model.creatorRequestId);
            this.numberOfRecoveryPoints(model.numberOfRecoveryPoints);
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        public final String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final Long getNumberOfRecoveryPoints() {
            return this.numberOfRecoveryPoints;
        }

        @Override
        public final Builder numberOfRecoveryPoints(Long numberOfRecoveryPoints) {
            this.numberOfRecoveryPoints = numberOfRecoveryPoints;
            return this;
        }

        public final void setNumberOfRecoveryPoints(Long numberOfRecoveryPoints) {
            this.numberOfRecoveryPoints = numberOfRecoveryPoints;
        }

        @Override
        public DescribeBackupVaultResponse build() {
            return new DescribeBackupVaultResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBackupVaultResponse> {
        public Builder backupVaultName(String var1);

        public Builder backupVaultArn(String var1);

        public Builder encryptionKeyArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder creatorRequestId(String var1);

        public Builder numberOfRecoveryPoints(Long var1);
    }
}

