/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse;

public class ListRecoveryPointsByResourcePublisher
implements SdkPublisher<ListRecoveryPointsByResourceResponse> {
    private final BackupAsyncClient client;
    private final ListRecoveryPointsByResourceRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecoveryPointsByResourcePublisher(BackupAsyncClient client, ListRecoveryPointsByResourceRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecoveryPointsByResourcePublisher(BackupAsyncClient client, ListRecoveryPointsByResourceRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecoveryPointsByResourceResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecoveryPointsByResourceResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRecoveryPointsByResourceResponseFetcher
    implements AsyncPageFetcher<ListRecoveryPointsByResourceResponse> {
        private ListRecoveryPointsByResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListRecoveryPointsByResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecoveryPointsByResourceResponse> nextPage(ListRecoveryPointsByResourceResponse previousPage) {
            if (previousPage == null) {
                return ListRecoveryPointsByResourcePublisher.this.client.listRecoveryPointsByResource(ListRecoveryPointsByResourcePublisher.this.firstRequest);
            }
            return ListRecoveryPointsByResourcePublisher.this.client.listRecoveryPointsByResource((ListRecoveryPointsByResourceRequest)((Object)ListRecoveryPointsByResourcePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

