/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.BackupVaultListCopier;
import software.amazon.awssdk.services.backup.model.BackupVaultListMember;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBackupVaultsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListBackupVaultsResponse> {
    private static final SdkField<List<BackupVaultListMember>> BACKUP_VAULT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListBackupVaultsResponse.getter(ListBackupVaultsResponse::backupVaultList)).setter(ListBackupVaultsResponse.setter(Builder::backupVaultList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackupVaultListMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListBackupVaultsResponse.getter(ListBackupVaultsResponse::nextToken)).setter(ListBackupVaultsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<BackupVaultListMember> backupVaultList;
    private final String nextToken;

    private ListBackupVaultsResponse(BuilderImpl builder) {
        super(builder);
        this.backupVaultList = builder.backupVaultList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasBackupVaultList() {
        return this.backupVaultList != null && !(this.backupVaultList instanceof SdkAutoConstructList);
    }

    public List<BackupVaultListMember> backupVaultList() {
        return this.backupVaultList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupVaultsResponse)) {
            return false;
        }
        ListBackupVaultsResponse other = (ListBackupVaultsResponse)((Object)obj);
        return Objects.equals(this.backupVaultList(), other.backupVaultList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListBackupVaultsResponse").add("BackupVaultList", this.backupVaultList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultList": {
                return Optional.ofNullable(clazz.cast(this.backupVaultList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupVaultsResponse, T> g) {
        return obj -> g.apply((ListBackupVaultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private List<BackupVaultListMember> backupVaultList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupVaultsResponse model) {
            super(model);
            this.backupVaultList(model.backupVaultList);
            this.nextToken(model.nextToken);
        }

        public final Collection<BackupVaultListMember.Builder> getBackupVaultList() {
            return this.backupVaultList != null ? (Collection)this.backupVaultList.stream().map(BackupVaultListMember::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder backupVaultList(Collection<BackupVaultListMember> backupVaultList) {
            this.backupVaultList = BackupVaultListCopier.copy(backupVaultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupVaultList(BackupVaultListMember ... backupVaultList) {
            this.backupVaultList(Arrays.asList(backupVaultList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupVaultList(Consumer<BackupVaultListMember.Builder> ... backupVaultList) {
            this.backupVaultList(Stream.of(backupVaultList).map(c -> (BackupVaultListMember)((BackupVaultListMember.Builder)BackupVaultListMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBackupVaultList(Collection<BackupVaultListMember.BuilderImpl> backupVaultList) {
            this.backupVaultList = BackupVaultListCopier.copyFromBuilder(backupVaultList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBackupVaultsResponse build() {
            return new ListBackupVaultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBackupVaultsResponse> {
        public Builder backupVaultList(Collection<BackupVaultListMember> var1);

        public Builder backupVaultList(BackupVaultListMember ... var1);

        public Builder backupVaultList(Consumer<BackupVaultListMember.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

