/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BackupVaultEvent {
    BACKUP_JOB_STARTED("BACKUP_JOB_STARTED"),
    BACKUP_JOB_COMPLETED("BACKUP_JOB_COMPLETED"),
    RESTORE_JOB_STARTED("RESTORE_JOB_STARTED"),
    RESTORE_JOB_COMPLETED("RESTORE_JOB_COMPLETED"),
    RECOVERY_POINT_MODIFIED("RECOVERY_POINT_MODIFIED"),
    BACKUP_PLAN_CREATED("BACKUP_PLAN_CREATED"),
    BACKUP_PLAN_MODIFIED("BACKUP_PLAN_MODIFIED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BackupVaultEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BackupVaultEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BackupVaultEvent.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BackupVaultEvent> knownValues() {
        return Stream.of(BackupVaultEvent.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

