/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.BackupVaultEvent;
import software.amazon.awssdk.services.backup.model.BackupVaultEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBackupVaultNotificationsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, GetBackupVaultNotificationsResponse> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBackupVaultNotificationsResponse.getter(GetBackupVaultNotificationsResponse::backupVaultName)).setter(GetBackupVaultNotificationsResponse.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBackupVaultNotificationsResponse.getter(GetBackupVaultNotificationsResponse::backupVaultArn)).setter(GetBackupVaultNotificationsResponse.setter(Builder::backupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBackupVaultNotificationsResponse.getter(GetBackupVaultNotificationsResponse::snsTopicArn)).setter(GetBackupVaultNotificationsResponse.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SNSTopicArn").build()}).build();
    private static final SdkField<List<String>> BACKUP_VAULT_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetBackupVaultNotificationsResponse.getter(GetBackupVaultNotificationsResponse::backupVaultEventsAsStrings)).setter(GetBackupVaultNotificationsResponse.setter(Builder::backupVaultEventsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD, BACKUP_VAULT_ARN_FIELD, SNS_TOPIC_ARN_FIELD, BACKUP_VAULT_EVENTS_FIELD));
    private final String backupVaultName;
    private final String backupVaultArn;
    private final String snsTopicArn;
    private final List<String> backupVaultEvents;

    private GetBackupVaultNotificationsResponse(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultArn = builder.backupVaultArn;
        this.snsTopicArn = builder.snsTopicArn;
        this.backupVaultEvents = builder.backupVaultEvents;
    }

    public String backupVaultName() {
        return this.backupVaultName;
    }

    public String backupVaultArn() {
        return this.backupVaultArn;
    }

    public String snsTopicArn() {
        return this.snsTopicArn;
    }

    public List<BackupVaultEvent> backupVaultEvents() {
        return BackupVaultEventsCopier.copyStringToEnum(this.backupVaultEvents);
    }

    public List<String> backupVaultEventsAsStrings() {
        return this.backupVaultEvents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultEventsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackupVaultNotificationsResponse)) {
            return false;
        }
        GetBackupVaultNotificationsResponse other = (GetBackupVaultNotificationsResponse)((Object)obj);
        return Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.backupVaultArn(), other.backupVaultArn()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.backupVaultEventsAsStrings(), other.backupVaultEventsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"GetBackupVaultNotificationsResponse").add("BackupVaultName", (Object)this.backupVaultName()).add("BackupVaultArn", (Object)this.backupVaultArn()).add("SNSTopicArn", (Object)this.snsTopicArn()).add("BackupVaultEvents", this.backupVaultEventsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "BackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.backupVaultArn()));
            }
            case "SNSTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "BackupVaultEvents": {
                return Optional.ofNullable(clazz.cast(this.backupVaultEventsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBackupVaultNotificationsResponse, T> g) {
        return obj -> g.apply((GetBackupVaultNotificationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String backupVaultName;
        private String backupVaultArn;
        private String snsTopicArn;
        private List<String> backupVaultEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackupVaultNotificationsResponse model) {
            super(model);
            this.backupVaultName(model.backupVaultName);
            this.backupVaultArn(model.backupVaultArn);
            this.snsTopicArn(model.snsTopicArn);
            this.backupVaultEventsWithStrings(model.backupVaultEvents);
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        public final String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final Collection<String> getBackupVaultEventsAsStrings() {
            return this.backupVaultEvents;
        }

        @Override
        public final Builder backupVaultEventsWithStrings(Collection<String> backupVaultEvents) {
            this.backupVaultEvents = BackupVaultEventsCopier.copy(backupVaultEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupVaultEventsWithStrings(String ... backupVaultEvents) {
            this.backupVaultEventsWithStrings(Arrays.asList(backupVaultEvents));
            return this;
        }

        @Override
        public final Builder backupVaultEvents(Collection<BackupVaultEvent> backupVaultEvents) {
            this.backupVaultEvents = BackupVaultEventsCopier.copyEnumToString(backupVaultEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupVaultEvents(BackupVaultEvent ... backupVaultEvents) {
            this.backupVaultEvents(Arrays.asList(backupVaultEvents));
            return this;
        }

        public final void setBackupVaultEventsWithStrings(Collection<String> backupVaultEvents) {
            this.backupVaultEvents = BackupVaultEventsCopier.copy(backupVaultEvents);
        }

        @Override
        public GetBackupVaultNotificationsResponse build() {
            return new GetBackupVaultNotificationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBackupVaultNotificationsResponse> {
        public Builder backupVaultName(String var1);

        public Builder backupVaultArn(String var1);

        public Builder snsTopicArn(String var1);

        public Builder backupVaultEventsWithStrings(Collection<String> var1);

        public Builder backupVaultEventsWithStrings(String ... var1);

        public Builder backupVaultEvents(Collection<BackupVaultEvent> var1);

        public Builder backupVaultEvents(BackupVaultEvent ... var1);
    }
}

