/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.BackupSelectionsListCopier;
import software.amazon.awssdk.services.backup.model.BackupSelectionsListMember;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBackupSelectionsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListBackupSelectionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListBackupSelectionsResponse.getter(ListBackupSelectionsResponse::nextToken)).setter(ListBackupSelectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<BackupSelectionsListMember>> BACKUP_SELECTIONS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListBackupSelectionsResponse.getter(ListBackupSelectionsResponse::backupSelectionsList)).setter(ListBackupSelectionsResponse.setter(Builder::backupSelectionsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSelectionsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackupSelectionsListMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, BACKUP_SELECTIONS_LIST_FIELD));
    private final String nextToken;
    private final List<BackupSelectionsListMember> backupSelectionsList;

    private ListBackupSelectionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.backupSelectionsList = builder.backupSelectionsList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<BackupSelectionsListMember> backupSelectionsList() {
        return this.backupSelectionsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSelectionsList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupSelectionsResponse)) {
            return false;
        }
        ListBackupSelectionsResponse other = (ListBackupSelectionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.backupSelectionsList(), other.backupSelectionsList());
    }

    public String toString() {
        return ToString.builder((String)"ListBackupSelectionsResponse").add("NextToken", (Object)this.nextToken()).add("BackupSelectionsList", this.backupSelectionsList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "BackupSelectionsList": {
                return Optional.ofNullable(clazz.cast(this.backupSelectionsList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupSelectionsResponse, T> g) {
        return obj -> g.apply((ListBackupSelectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<BackupSelectionsListMember> backupSelectionsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupSelectionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.backupSelectionsList(model.backupSelectionsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<BackupSelectionsListMember.Builder> getBackupSelectionsList() {
            return this.backupSelectionsList != null ? (Collection)this.backupSelectionsList.stream().map(BackupSelectionsListMember::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder backupSelectionsList(Collection<BackupSelectionsListMember> backupSelectionsList) {
            this.backupSelectionsList = BackupSelectionsListCopier.copy(backupSelectionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupSelectionsList(BackupSelectionsListMember ... backupSelectionsList) {
            this.backupSelectionsList(Arrays.asList(backupSelectionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupSelectionsList(Consumer<BackupSelectionsListMember.Builder> ... backupSelectionsList) {
            this.backupSelectionsList(Stream.of(backupSelectionsList).map(c -> (BackupSelectionsListMember)((BackupSelectionsListMember.Builder)BackupSelectionsListMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBackupSelectionsList(Collection<BackupSelectionsListMember.BuilderImpl> backupSelectionsList) {
            this.backupSelectionsList = BackupSelectionsListCopier.copyFromBuilder(backupSelectionsList);
        }

        @Override
        public ListBackupSelectionsResponse build() {
            return new ListBackupSelectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBackupSelectionsResponse> {
        public Builder nextToken(String var1);

        public Builder backupSelectionsList(Collection<BackupSelectionsListMember> var1);

        public Builder backupSelectionsList(BackupSelectionsListMember ... var1);

        public Builder backupSelectionsList(Consumer<BackupSelectionsListMember.Builder> ... var1);
    }
}

