/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.json.internal.unmarshall;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.protocols.json.ErrorCodeParser;
import software.amazon.awssdk.protocols.json.JsonContent;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;

@SdkInternalApi
public class JsonErrorCodeParser
implements ErrorCodeParser {
    public static final String X_AMZN_ERROR_TYPE = "x-amzn-ErrorType";
    static final String ERROR_CODE_HEADER = ":error-code";
    static final String EXCEPTION_TYPE_HEADER = ":exception-type";
    static final List<String> ERROR_CODE_FIELDS = Collections.unmodifiableList(Arrays.asList("__type", "code"));
    private final List<String> errorCodeHeaders;
    private final List<String> errorCodeFieldNames;

    public JsonErrorCodeParser(String customErrorCodeFieldName) {
        this.errorCodeFieldNames = customErrorCodeFieldName == null ? ERROR_CODE_FIELDS : Collections.singletonList(customErrorCodeFieldName);
        this.errorCodeHeaders = Arrays.asList(X_AMZN_ERROR_TYPE, ERROR_CODE_HEADER, EXCEPTION_TYPE_HEADER);
    }

    @Override
    public String parseErrorCode(SdkHttpFullResponse response, JsonContent jsonContent) {
        String errorCodeFromHeader = this.parseErrorCodeFromHeader(response);
        if (errorCodeFromHeader != null) {
            return errorCodeFromHeader;
        }
        if (jsonContent != null) {
            return this.parseErrorCodeFromContents(jsonContent.getJsonNode());
        }
        return null;
    }

    private String parseErrorCodeFromHeader(SdkHttpFullResponse response) {
        for (String errorCodeHeader : this.errorCodeHeaders) {
            Optional errorCode = response.firstMatchingHeader(errorCodeHeader);
            if (!errorCode.isPresent()) continue;
            if (X_AMZN_ERROR_TYPE.equals(errorCodeHeader)) {
                return this.parseErrorCodeFromXAmzErrorType((String)errorCode.get());
            }
            return (String)errorCode.get();
        }
        return null;
    }

    private String parseErrorCodeFromXAmzErrorType(String headerValue) {
        if (headerValue != null) {
            return JsonErrorCodeParser.parseErrorCode(headerValue);
        }
        return headerValue;
    }

    private String parseErrorCodeFromContents(JsonNode jsonContents) {
        if (jsonContents == null) {
            return null;
        }
        JsonNode errorCodeField = this.errorCodeFieldNames.stream().map(arg_0 -> ((JsonNode)jsonContents).field(arg_0)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
        if (errorCodeField == null) {
            return null;
        }
        return JsonErrorCodeParser.parseErrorCode(errorCodeField.text());
    }

    private static String parseErrorCode(String value) {
        int hashIndex;
        if (value == null || value.isEmpty()) {
            return value;
        }
        int start = 0;
        int end = value.length();
        int colonIndex = value.indexOf(58);
        if (colonIndex >= 0) {
            end = colonIndex;
        }
        if ((hashIndex = value.indexOf(35)) >= 0 && hashIndex + 1 < end) {
            start = hashIndex + 1;
        }
        if (start == 0 && end == value.length()) {
            return value;
        }
        return value.substring(start, end);
    }
}

