/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.json.internal.unmarshall.document;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkNumber;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.protocols.json.internal.dom.SdkArrayNode;
import software.amazon.awssdk.protocols.json.internal.dom.SdkJsonNode;
import software.amazon.awssdk.protocols.json.internal.dom.SdkNullNode;
import software.amazon.awssdk.protocols.json.internal.dom.SdkObjectNode;
import software.amazon.awssdk.protocols.json.internal.dom.SdkScalarNode;
import software.amazon.awssdk.protocols.json.internal.visitor.SdkJsonNodeVisitor;

@SdkInternalApi
public class DocumentUnmarshaller
implements SdkJsonNodeVisitor<Document> {
    private Document visitMap(SdkJsonNode jsonContent) {
        return Document.fromMap((Map)jsonContent.fields().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> this.visit((SdkJsonNode)entry.getValue()), (left, right) -> left, LinkedHashMap::new)));
    }

    private Document visitList(SdkJsonNode jsonContent) {
        return Document.fromList(((SdkArrayNode)jsonContent).items().stream().map(item -> this.visit((SdkJsonNode)item)).collect(Collectors.toList()));
    }

    private Document visitScalar(SdkJsonNode jsonContent) {
        SdkScalarNode sdkScalarNode = (SdkScalarNode)jsonContent;
        switch (sdkScalarNode.getNodeType()) {
            case BOOLEAN: {
                return Document.fromBoolean((boolean)Boolean.valueOf(sdkScalarNode.asText()));
            }
            case NUMBER: {
                return Document.fromNumber((SdkNumber)SdkNumber.fromString((String)jsonContent.asText()));
            }
        }
        return Document.fromString((String)sdkScalarNode.asText());
    }

    @Override
    public Document visit(SdkJsonNode sdkJsonNode) {
        if (sdkJsonNode instanceof SdkScalarNode) {
            return this.visitScalar(sdkJsonNode);
        }
        if (sdkJsonNode instanceof SdkObjectNode) {
            return this.visitMap(sdkJsonNode);
        }
        if (sdkJsonNode instanceof SdkArrayNode) {
            return this.visitList(sdkJsonNode);
        }
        if (sdkJsonNode instanceof SdkNullNode) {
            return this.visitNull();
        }
        throw new IllegalStateException("Visitor not defined for " + sdkJsonNode);
    }

    private Document visitNull() {
        return Document.fromNull();
    }
}

